/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.erp.dev;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.erp.metaobjectchange.MetaObjectChangeListener;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class TableRelation {
    private static final Map<MetaDataObject, TableRelation> cache = new HashMap<MetaDataObject, TableRelation>();
    private Map<String, String[]> relations = new HashMap<String, String[]>();

    static {
        MetaObjectChange.register((MetaObjectChangeListener)new MetaObjectChangeListener(){

            public void changeMetaForm(MetaForm metaForm) throws Throwable {
                MetaDataSource dataSource = metaForm.getDataSource();
                if (dataSource != null) {
                    cache.remove(dataSource.getDataObject());
                }
            }

            public void changeMetaDataObject(MetaDataObject metaDataObject) throws Throwable {
                cache.remove(metaDataObject);
            }

            public void changeMetaAll() {
                cache.clear();
            }
        }, (String)"TableCache");
    }

    public static TableRelation getTableRelation(MetaDataObject dataObject) {
        TableRelation result = cache.get(dataObject);
        if (result == null) {
            result = new TableRelation(dataObject);
            cache.put(dataObject, result);
        }
        return result;
    }

    public TableRelation(MetaDataObject dataObject) {
        MetaTableCollection tables = dataObject.getTableCollection();
        if (tables != null) {
            for (MetaTable table : tables) {
                String tableKey = table.getKey();
                String parentTableKey = table.getParentKey();
                if (!(parentTableKey != null && parentTableKey.length() != 0 || table.isHead())) {
                    parentTableKey = dataObject.getMainTableKey();
                }
                this.relations.put(tableKey, this.getParentTables(tables, parentTableKey));
            }
        }
    }

    private String[] getParentTables(MetaTableCollection tables, String parentTableKey) {
        String[] parentParentTableKeys;
        if (parentTableKey == null || parentTableKey.length() == 0) {
            return null;
        }
        String[] stringArray = parentParentTableKeys = this.relations.containsKey(parentTableKey) ? this.relations.get(parentTableKey) : this.getParentTables(tables, ((MetaTable)tables.get(parentTableKey)).getParentKey());
        if (parentParentTableKeys == null) {
            return new String[]{parentTableKey};
        }
        int parentParentTableSize = parentParentTableKeys.length;
        String[] result = new String[parentParentTableSize + 1];
        System.arraycopy(parentParentTableKeys, 0, result, 0, parentParentTableSize);
        result[parentParentTableSize] = parentTableKey;
        return result;
    }

    public Relation relation(String tableKeyA, String tableKeyB) {
        Object[] tableKeyAParents = this.relations.get(tableKeyA);
        if (ArrayUtils.contains((Object[])tableKeyAParents, (Object)tableKeyB)) {
            return Relation.son;
        }
        Object[] tableKeyBParents = this.relations.get(tableKeyB);
        if (ArrayUtils.contains((Object[])tableKeyBParents, (Object)tableKeyA)) {
            return Relation.parent;
        }
        return Relation.noRelation;
    }

    public String[] getParentTableKeys(String tableKey) {
        return this.relations.get(tableKey);
    }

    public static enum Relation {
        parent,
        son,
        noRelation;

    }
}

