/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct.metaload;

import com.bokesoft.yes.datastruct.meta.MetaDataStruct;
import com.bokesoft.yes.datastruct.meta.MetaDataStructColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSource;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSourceColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructTable;
import com.bokesoft.yes.datastruct.metaload.ColumnExp;
import com.bokesoft.yes.datastruct.metaload.DataStructSourceTableNode;
import com.bokesoft.yes.datastruct.metaload.DataStructUtils;
import com.bokesoft.yes.datastruct.metaload.WhereExp;
import com.bokesoft.yes.datastruct.metaload.WhereExpUtils;
import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.erp.dev.TableRelation;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataStructSourceTableTree {
    DataStructSourceTableNode root;

    public DataStructSourceTableTree(MetaDataStruct struct, MetaDataStructSource source) throws Throwable {
        HashMap<MetaDataStructTable, DataStructSourceTableNode> mapForTree = new HashMap<MetaDataStructTable, DataStructSourceTableNode>();
        Iterator iterator = source.getColumnCollection().iterator();
        while (iterator.hasNext()) {
            MetaDataStructSourceColumn sourceColumn = (MetaDataStructSourceColumn)iterator.next();
            MetaDataStructColumn column = (MetaDataStructColumn)struct.getColumnCollection().get(sourceColumn.getKey());
            if (!column.isKeyField()) continue;
            MetaDataStructTable table = (MetaDataStructTable)struct.getTableCollection().get(column.getDataStructTableKey());
            String originalRealTable = sourceColumn.getOriginalRealTable();
            if (table.getRefTable().equalsIgnoreCase(originalRealTable)) {
                if (!"OID".equalsIgnoreCase(sourceColumn.getOriginalColumn())) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u4e2d\u7684\u5b57\u6bb5" + sourceColumn.getKey() + "\u6307\u5411\u81ea\u8eab\uff0c\u4f46\u6ca1\u6709\u6307\u5411OID\u5b57\u6bb5\u3002"));
                }
                if (this.root != null) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + source.getKey() + "\u5b58\u5728\u4e24\u4e2a\u6839\u8868\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u3002"));
                }
                this.root = DataStructSourceTableTree.getNode(source, mapForTree, table);
                this.root.setSourceColumn(sourceColumn);
                continue;
            }
            MetaDataStructTable originalTable = struct.getTableByTableName(originalRealTable);
            DataStructSourceTableNode node = DataStructSourceTableTree.addChild(source, mapForTree, originalTable, table);
            node.setSourceColumn(sourceColumn);
        }
        Map<MetaDataStructTable, WhereExp> whereExps = DataStructUtils.getStructTableWhereExpression(struct);
        Iterator iterator2 = struct.getTableCollection().iterator();
        while (iterator2.hasNext()) {
            MetaTable metaTable;
            MetaDataStructTable table = (MetaDataStructTable)iterator2.next();
            WhereExp whereExp = whereExps.get(table);
            if (whereExp == null || !whereExp.hasColumnWhereClause(new ColumnExp(table, (metaTable = MetaTableCache.getFullMetaTable(table.getRefTable())).getOIDColumn())) && !whereExp.hasColumnWhereClause(new ColumnExp(table, metaTable.getSOIDColumn()))) continue;
            List<MetaDataStructTable> tablesInWhereExp = whereExp.getTables();
            int pos = tablesInWhereExp.indexOf(table);
            if (tablesInWhereExp.size() != 2 || pos < 0) {
                throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784" + struct.getKey() + "\u8868" + table.getKey() + "\u4e2d\u7684\u6761\u4ef6\u6d89\u53ca\u591a\u5f20\u8868\uff0c\u6216\u4e0d\u5b58\u5728\u672c\u8868\uff0c\u9519\u8bef\u3002"));
            }
            MetaDataStructTable parentTable = tablesInWhereExp.get(pos == 0 ? 1 : 0);
            DataStructSourceTableTree.addChild(source, mapForTree, parentTable, table);
        }
        mapForTree.clear();
        DataStructSourceTableTree.checkChildren(this.root);
    }

    public DataStructSourceTableNode getRoot() {
        return this.root;
    }

    private static DataStructSourceTableNode getNode(MetaDataStructSource source, Map<MetaDataStructTable, DataStructSourceTableNode> mapForTree, MetaDataStructTable table) {
        DataStructSourceTableNode node = mapForTree.get(table);
        if (node == null) {
            node = new DataStructSourceTableNode(source, table);
            mapForTree.put(table, node);
        }
        return node;
    }

    private static DataStructSourceTableNode addChild(MetaDataStructSource source, Map<MetaDataStructTable, DataStructSourceTableNode> mapForTree, MetaDataStructTable parent, MetaDataStructTable child) {
        DataStructSourceTableNode childNode;
        DataStructSourceTableNode parentNode = mapForTree.get(parent);
        if (parentNode == null) {
            parentNode = new DataStructSourceTableNode(source, parent);
            mapForTree.put(parent, parentNode);
        }
        if ((childNode = mapForTree.get(child)) == null) {
            childNode = new DataStructSourceTableNode(source, child);
            mapForTree.put(child, childNode);
        }
        parentNode.addChild(childNode);
        return childNode;
    }

    private static void checkChildren(DataStructSourceTableNode node) throws Throwable {
        if (node.children == null || node.children.size() <= 1) {
            return;
        }
        MetaDataObject dataObject = node.getDataObject();
        ArrayList<DataStructSourceTableNode> needExamine = new ArrayList<DataStructSourceTableNode>();
        for (DataStructSourceTableNode child : node.children) {
            MetaDataObject childDataObject = child.getDataObject();
            if (dataObject == childDataObject) {
                TableRelation tableRelation = TableRelation.getTableRelation(dataObject);
                if (tableRelation.relation(child.table.getRefTable(), node.table.getRefTable()) == TableRelation.Relation.parent) continue;
                needExamine.add(child);
                continue;
            }
            if (DataObjects.getMetaTableByTableNameIgnoreCase(childDataObject, child.table.getRefTable()).isHead()) continue;
            needExamine.add(child);
        }
        int size = needExamine.size();
        if (size > 1) {
            MetaDataStructTable table = ((DataStructSourceTableNode)needExamine.get((int)0)).table;
            int i = 1;
            while (i < size) {
                if (((DataStructSourceTableNode)needExamine.get((int)i)).table != table) {
                    throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90" + node.source.getKey() + "\u7684\u8868" + node.table.getKey() + "\u4e2d\u5b58\u5728\u591a\u5bf9\u591a\u7684\u8868\u3002"));
                }
                ++i;
            }
            WhereExp[] whereExps = new WhereExp[size];
            int i2 = 1;
            while (i2 < size) {
                whereExps[i2] = ((DataStructSourceTableNode)needExamine.get(i2)).getWhereExp();
                ++i2;
            }
            int[] result = WhereExpUtils.checkWhereIsolation(whereExps, table);
            if (result != null) {
                throw new AssertionError((Object)("\u6570\u636e\u7ed3\u6784\u6e90\u8868" + table.getKey() + "\u7684\u6761\u4ef6" + whereExps[result[0]] + "\u548c" + whereExps[result[1]] + "\u6ca1\u6709\u9694\u79bb\u3002"));
            }
        }
    }

    public DataStructSourceTableNode getNode(MetaDataStructTable table) {
        return DataStructSourceTableTree.getNode(this.root, table);
    }

    private static DataStructSourceTableNode getNode(DataStructSourceTableNode node, MetaDataStructTable table) {
        if (node.table == table) {
            return node;
        }
        if (node.children != null) {
            for (DataStructSourceTableNode child : node.children) {
                DataStructSourceTableNode result = DataStructSourceTableTree.getNode(child, table);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }
}

