/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.datastruct;

import com.bokesoft.yes.datastruct.DataStructToolKit;
import com.bokesoft.yes.datastruct.meta.MetaDataStructColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructColumnCollection;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSource;
import com.bokesoft.yes.datastruct.meta.MetaDataStructSourceColumn;
import com.bokesoft.yes.datastruct.meta.MetaDataStructTable;
import com.bokesoft.yes.datastruct.metaload.DataStructSourceTableNode;
import com.bokesoft.yes.datastruct.metaload.DataStructSourceTableTree;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import org.apache.commons.lang3.NotImplementedException;

class DataStructSourceToolKit {
    final DataStructToolKit struct;
    public final MetaDataStructSource meta;
    private DataStructSourceTableTree tree;
    private SqlString relationLoadSql;

    public DataStructSourceToolKit(DataStructToolKit struct, MetaDataStructSource source) {
        this.struct = struct;
        this.meta = source;
    }

    private DataStructSourceTableTree getTree() throws Throwable {
        if (this.tree == null) {
            this.tree = new DataStructSourceTableTree(this.struct.meta, this.meta);
        }
        return this.tree;
    }

    public SqlString getRelationLoadSql() throws Throwable {
        if (this.relationLoadSql == null) {
            SqlString joinedTables = new SqlString(1024);
            DataStructSourceTableTree tree = this.getTree();
            this.genRelationLoadSql(tree.getRoot(), joinedTables);
            SqlString sql = new SqlString(1024);
            sql.append("SELECT 0 AS OID, 0 AS VERID, '", this.meta.getKey(), "' AS DataStructSource");
            MetaDataStructColumnCollection columns = this.struct.meta.getColumnCollection();
            int i = 0;
            int size = columns.size();
            while (i < size) {
                String dataStructTableKey;
                sql.append(", ");
                MetaDataStructColumn column = (MetaDataStructColumn)columns.get(i);
                if (column.isKeyField()) {
                    dataStructTableKey = column.getDataStructTableKey();
                    if (tree.getNode((MetaDataStructTable)this.struct.meta.getTableCollection().get(dataStructTableKey)) == null) {
                        sql.append(column.getDataType() == 1002 ? "''" : "0");
                    } else {
                        sql.append(dataStructTableKey, ".OID");
                    }
                    sql.append(" AS ", column.getKey());
                } else if (column.isTableRefField()) {
                    dataStructTableKey = column.getDataStructTableKey();
                    if (tree.getNode((MetaDataStructTable)this.struct.meta.getTableCollection().get(dataStructTableKey)) == null) {
                        sql.append(column.getDataType() == 1002 ? "''" : "0");
                    } else {
                        sql.append(dataStructTableKey, ".", column.getRefColumn());
                    }
                    sql.append(" AS ", column.getKey());
                } else {
                    String value;
                    MetaDataStructSourceColumn sourceColumn = (MetaDataStructSourceColumn)this.meta.getColumnCollection().get(column.getKey());
                    String string = value = sourceColumn != null ? sourceColumn.getConstValue() : null;
                    if (value == null || value.length() == 0) {
                        value = column.getDataType() == 1002 ? "''" : "0";
                    }
                    sql.append(value, " AS ", column.getKey());
                }
                ++i;
            }
            sql.append(" FROM ").append(joinedTables);
            this.relationLoadSql = sql;
        }
        return this.relationLoadSql;
    }

    private SqlString genRelationLoadSql(DataStructSourceTableNode root, SqlString sql) throws Throwable {
        sql.append(root.table.getRefTable()).append(" AS ").append(root.table.getKey());
        if (root.getChildren() != null) {
            for (DataStructSourceTableNode child : root.getChildren()) {
                this.genRelationLoadSql(root, child, sql);
            }
        }
        return sql;
    }

    private SqlString genRelationLoadSql(DataStructSourceTableNode parent, DataStructSourceTableNode child, SqlString sql) throws Throwable {
        boolean isRightOuterJoin;
        boolean isLeftOuterJoin = parent.getSourceColumn().isOuterJoin();
        boolean bl = isRightOuterJoin = child.getSourceColumn() == null ? false : child.getSourceColumn().isOuterJoin();
        if (isLeftOuterJoin && isRightOuterJoin) {
            throw new NotImplementedException("full outer join\u76ee\u524d\u8fd8\u6ca1\u6709\u5b9e\u73b0");
        }
        if (isLeftOuterJoin) {
            sql.append(" LEFT OUTER JOIN ");
        } else if (isRightOuterJoin) {
            sql.append(" RIGHT OUTER JOIN ");
        } else {
            sql.append(" JOIN ");
        }
        sql.append(child.table.getRefTable()).append(" AS ").append(child.table.getKey());
        sql.append(" ON ", child.getWhereExp().toSQL());
        if (child.getChildren() != null) {
            for (DataStructSourceTableNode childChild : child.getChildren()) {
                this.genRelationLoadSql(child, childChild, sql);
            }
        }
        return sql;
    }
}

