/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.connection.ArchiveDSNItems;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ArchiveDBUtil {
    public static Map<String, List<String>> archiveObjectList = new ConcurrentHashMap<String, List<String>>();
    public static Map<String, List<String>> archiveTableList = new ConcurrentHashMap<String, List<String>>();
    public static ICache<Object> ARCHIVEDATACACHE = null;
    private static final String ArchiveObjectListCacheKey = "ArchiveObjectListCacheKey";
    private static final String ArchiveTableListCacheKey = "ArchiveTableListCacheKey";

    static {
        try {
            archiveObjectList.computeIfAbsent(ArchiveObjectListCacheKey, key -> {
                try {
                    return ArchiveDBUtil.getAllArchiveObject();
                }
                catch (Throwable e) {
                    return Collections.emptyList();
                }
            });
            archiveTableList.computeIfAbsent(ArchiveTableListCacheKey, key -> {
                try {
                    return ArchiveDBUtil.getAllArchiveTable();
                }
                catch (Throwable e) {
                    return Collections.emptyList();
                }
            });
            ARCHIVEDATACACHE = CacheFactory.getInstance().createCache("ArchiveData");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static boolean isEnsureArchive() {
        ArchiveDSNItems dsnCollection = ArchiveDSNItems.instance;
        return dsnCollection != null && dsnCollection.getDSNItemSize() > 0;
    }

    public static boolean isEnsureArchive(String dsn) {
        ArchiveDSNItems dsnCollection = ArchiveDSNItems.instance;
        return dsnCollection != null && dsnCollection.getDSNItemSize() > 0 && dsnCollection.getDSNItem(dsn) != null;
    }

    public static boolean isArchivedData(DefaultContext context, String dataObjectKey, Long oid) throws Throwable {
        if (!ArchiveDBUtil.isEnsureArchive()) {
            return false;
        }
        if (!StringUtil.isBlankOrNull((String)dataObjectKey) && dataObjectKey.endsWith("__Dic")) {
            dataObjectKey = dataObjectKey.substring(0, dataObjectKey.lastIndexOf("__Dic"));
        }
        if (!StringUtil.isBlankOrNull((String)dataObjectKey) && !ArchiveDBUtil.isArchiveObject(context, dataObjectKey)) {
            return false;
        }
        DefaultContext newContext = null;
        IDBManager dbManager = null;
        String sql = "";
        DataTable tmp = null;
        try {
            newContext = new DefaultContext(context.getVE());
            dbManager = newContext.getDBManager();
            if (!StringUtil.isBlankOrNull((String)dataObjectKey)) {
                sql = "select h.DSN from EDA_ArchiveRecordHead h inner join EDA_ArchiveRecordDetail l on h.OID = l.SOID Where h.DataObjectKey = ? and l.ArchiveDataSOID = ?";
                tmp = dbManager.execPrepareQuery(sql, new Object[]{dataObjectKey, oid});
            } else {
                sql = "select * from EDA_ArchiveRecordDetail Where l.ArchiveDataSOID = ?";
                tmp = dbManager.execPrepareQuery(sql, new Object[]{oid});
            }
            if (tmp != null && tmp.size() > 0) {
                return true;
            }
        }
        finally {
            if (newContext != null) {
                newContext.close();
            }
        }
        return false;
    }

    public static boolean isArchiveObject(DefaultContext context, String dataObjectKey) throws Throwable {
        if (archiveObjectList.size() == 0) {
            return false;
        }
        if (!StringUtil.isBlankOrNull((String)dataObjectKey) && dataObjectKey.endsWith("__Dic")) {
            dataObjectKey = dataObjectKey.substring(0, dataObjectKey.lastIndexOf("__Dic"));
        }
        return archiveObjectList.get(ArchiveObjectListCacheKey).contains(dataObjectKey);
    }

    public static boolean isArchiveTable(DefaultContext context, String tableKey) throws Throwable {
        if (archiveTableList.size() == 0) {
            return false;
        }
        return archiveTableList.get(ArchiveTableListCacheKey).contains(tableKey);
    }

    private static CopyOnWriteArrayList<String> getAllArchiveObject() throws Throwable {
        CopyOnWriteArrayList<String> list = new CopyOnWriteArrayList<String>();
        try (DefaultContext newContext = null;){
            newContext = ContextBuilder.create();
            IDBManager dbManager = newContext.getDBManager();
            String sql = "select DataObjectKey from EDA_ArchiveObject";
            DataTable dt = dbManager.execPrepareQuery(sql, new Object[0]);
            if (dt != null && dt.size() > 0) {
                dt.beforeFirst();
                while (dt.next()) {
                    list.add(dt.getString(0));
                }
            }
        }
        return list;
    }

    private static CopyOnWriteArrayList<String> getAllArchiveTable() throws Throwable {
        CopyOnWriteArrayList<String> list = new CopyOnWriteArrayList<String>();
        try (DefaultContext newContext = null;){
            newContext = ContextBuilder.create();
            IDBManager dbManager = newContext.getDBManager();
            String sql = "select TableKey from EDA_ArchiveObjectTableDtl";
            DataTable dt = dbManager.execPrepareQuery(sql, new Object[0]);
            if (dt != null && dt.size() > 0) {
                dt.beforeFirst();
                while (dt.next()) {
                    list.add(dt.getString(0));
                }
            }
        }
        return list;
    }

    public static Map<String, List<Long>> getAllArchivedData(DefaultContext context, String dataObjectKey) throws Throwable {
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        try (DefaultContext newContext = null;){
            newContext = new DefaultContext(context.getVE());
            IDBManager dbManager = newContext.getDBManager();
            String sql = "select h.DSN, l.ArchiveDataSOID from EDA_ArchiveRecordHead h inner join EDA_ArchiveRecordDetail l on h.OID = l.SOID Where h.DataObjectKey = ?";
            DataTable tmp = dbManager.execPrepareQuery(sql, new Object[]{dataObjectKey});
            if (tmp != null && tmp.size() > 0) {
                tmp.beforeFirst();
                while (tmp.next()) {
                    String dsn = tmp.getString("DSN");
                    Long archiveDataSOID = tmp.getLong("ArchiveDataSOID");
                    map.computeIfAbsent(dsn, key -> new ArrayList()).add(archiveDataSOID);
                }
            }
        }
        return map;
    }

    public static String getArchivedDsnById(DefaultContext context, String dataObjectKey, Long oid) throws Throwable {
        if (!ArchiveDBUtil.isEnsureArchive()) {
            return "";
        }
        if (!StringUtil.isBlankOrNull((String)dataObjectKey) && dataObjectKey.endsWith("__Dic")) {
            dataObjectKey = dataObjectKey.substring(0, dataObjectKey.lastIndexOf("__Dic"));
        }
        if (!StringUtil.isBlankOrNull((String)dataObjectKey) && !ArchiveDBUtil.isArchiveObject(context, dataObjectKey)) {
            return "";
        }
        DefaultContext newContext = null;
        IDBManager dbManager = null;
        String sql = "";
        DataTable tmp = null;
        try {
            newContext = new DefaultContext(context.getVE());
            dbManager = newContext.getDBManager();
            if (!StringUtil.isBlankOrNull((String)dataObjectKey)) {
                sql = "select h.DSN from EDA_ArchiveRecordHead h inner join EDA_ArchiveRecordDetail l on h.OID = l.SOID Where h.DataObjectKey = ? and l.ArchiveDataSOID = ?";
                tmp = dbManager.execPrepareQuery(sql, new Object[]{dataObjectKey, oid});
            } else {
                sql = "select h.DSN from EDA_ArchiveRecordHead h inner join EDA_ArchiveRecordDetail l on h.OID = l.SOID Where l.ArchiveDataSOID = ?";
                tmp = dbManager.execPrepareQuery(sql, new Object[]{oid});
            }
            if (tmp != null && tmp.size() > 0) {
                tmp.beforeFirst();
                if (tmp.next()) {
                    String string = tmp.getString("DSN");
                    return string;
                }
            }
        }
        finally {
            if (newContext != null) {
                newContext.close();
            }
        }
        return "";
    }

    public static String getArchivedDsnByRecordId(DefaultContext context, Long archiveRecordSOID) throws Throwable {
        if (!ArchiveDBUtil.isEnsureArchive()) {
            return "";
        }
        DefaultContext newContext = null;
        IDBManager dbManager = null;
        String sql = "";
        DataTable tmp = null;
        try {
            newContext = new DefaultContext(context.getVE());
            dbManager = newContext.getDBManager();
            sql = "select h.DSN from EDA_ArchiveRecordHead h Where h.SOID = ?";
            tmp = dbManager.execPrepareQuery(sql, new Object[]{archiveRecordSOID});
            if (tmp != null && tmp.size() > 0) {
                tmp.beforeFirst();
                if (tmp.next()) {
                    String string = tmp.getString("DSN");
                    return string;
                }
            }
        }
        finally {
            if (newContext != null) {
                newContext.close();
            }
        }
        return "";
    }
}

