/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.mid.schema;

import com.bokesoft.yes.mid.connection.dbmanager.MySqlClusterDBManager;
import com.bokesoft.yigo.meta.schema.MetaIndex;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import com.bokesoft.yigo.mid.connection.DataBaseInfo;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.connection.PartitionInfo;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCheck;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ERPSchemaCheck
implements ISchemaCheck {
    private IDBManager dbManager;
    private MetaSchemaTable table;
    private DataBaseInfo info;
    private boolean columnChange;

    public ERPSchemaCheck(IDBManager dbManager, MetaSchemaTable table, DataBaseInfo info) {
        this.dbManager = dbManager;
        this.table = table;
        this.info = info;
        this.columnChange = false;
    }

    public List<MetaSchemaColumn> checkTable(IDBManager DBManager, MetaSchemaTable table) throws Throwable {
        HashSet set = DBManager.getTableColumnSet(table.getKey());
        Iterator iterator = table.getColumnCollection().iterator();
        ArrayList<MetaSchemaColumn> list = new ArrayList<MetaSchemaColumn>();
        while (iterator.hasNext()) {
            MetaSchemaColumn metaColumn = (MetaSchemaColumn)iterator.next();
            if (set.contains(metaColumn.getKey().toUpperCase())) continue;
            list.add(metaColumn);
        }
        return list;
    }

    public List<MetaSchemaColumn> checkTable() throws Throwable {
        HashSet tableColumnSet = this.info.getTableColumnSet(this.table.getKey());
        Iterator it = this.table.getColumnCollection().iterator();
        ArrayList<MetaSchemaColumn> columns = new ArrayList<MetaSchemaColumn>();
        while (it.hasNext()) {
            MetaSchemaColumn column = (MetaSchemaColumn)it.next();
            if (tableColumnSet.contains(column.getKey().toUpperCase())) continue;
            columns.add(column);
        }
        this.columnChange = !columns.isEmpty();
        return columns;
    }

    public List<MetaSchemaColumn> checkKeysMigrationTable() throws Throwable {
        HashSet tableColumnSetNew = this.info.getTableColumnSet(String.valueOf(this.table.getKey()) + "_NEW");
        HashSet tableColumnSetKeys = this.info.getTableColumnSet(String.valueOf(this.table.getKey()) + "_KEYS");
        Iterator it = this.table.getColumnCollection().iterator();
        ArrayList<MetaSchemaColumn> columns = new ArrayList<MetaSchemaColumn>();
        while (it.hasNext()) {
            MetaSchemaColumn column = (MetaSchemaColumn)it.next();
            if (tableColumnSetNew.contains(column.getKey().toUpperCase()) || tableColumnSetKeys.contains(column.getKey().toUpperCase())) continue;
            columns.add(column);
        }
        return columns;
    }

    public List<MetaIndex> checkIndex() throws Throwable {
        String tableKey = this.table.getKey();
        HashSet indexSet = this.info.getIndexSet(tableKey);
        HashMap indexColumnSet = this.info.getIndexColumnSet(tableKey);
        HashMap uniqueIndexSet = this.info.getUniqueIndexSet(tableKey);
        Iterator it = this.table.getIndexCollection().iterator();
        ArrayList<MetaIndex> indexList = new ArrayList<MetaIndex>();
        while (it.hasNext()) {
            MetaIndex metaIndex = (MetaIndex)it.next();
            String indexName = metaIndex.getKey().toUpperCase();
            if (!indexSet.contains(metaIndex.getKey().toUpperCase()) || tableKey.endsWith("_KEYS") && this.table.isMigration() && this.columnChange) {
                indexList.add(metaIndex);
                continue;
            }
            if (indexColumnSet.get(indexName) != null && !((String)indexColumnSet.get(indexName)).equalsIgnoreCase(metaIndex.getColumns())) {
                indexList.add(metaIndex);
                continue;
            }
            if (indexName.endsWith("_SOID") || uniqueIndexSet.get(indexName) == null || ((Boolean)uniqueIndexSet.get(indexName)).equals(metaIndex.isUnique())) continue;
            indexList.add(metaIndex);
        }
        return indexList;
    }

    public List<MetaIndex> checkIndex(IDBManager DBManager, MetaSchemaTable table) throws Throwable {
        HashSet set = DBManager.getIndexSet(table.getKey());
        Iterator iterator = table.getIndexCollection().iterator();
        ArrayList<MetaIndex> list = new ArrayList<MetaIndex>();
        while (iterator.hasNext()) {
            MetaIndex metaColumn = (MetaIndex)iterator.next();
            if (set.contains(metaColumn.getKey().toUpperCase())) continue;
            list.add(metaColumn);
        }
        return list;
    }

    public boolean checkPartition(DataBaseInfo info) throws Throwable {
        if (info == null) {
            return this.checkPartition(this.dbManager);
        }
        if (this.dbManager.getDBType() != 6) {
            return true;
        }
        PartitionInfo partitionInfo = info.getPartitionInfo(this.table.getKey());
        if (!this.table.getPartitionMethod().equals(partitionInfo.getPartitionMethod())) {
            return false;
        }
        return partitionInfo.isPartitionColumnEqual(this.table.getPartitionColumnSet());
    }

    public boolean checkPartition(IDBManager dbManager, MetaSchemaTable table, DataBaseInfo dbinfo) throws Throwable {
        if (dbinfo == null) {
            return this.checkPartition(dbManager, table);
        }
        if (dbManager.getDBType() != 6) {
            return true;
        }
        PartitionInfo info = dbinfo.getPartitionInfo(table.getKey());
        if (!table.getPartitionMethod().equals(info.getPartitionMethod())) {
            return false;
        }
        return info.isPartitionColumnEqual(table.getPartitionColumnSet());
    }

    private boolean checkPartition(IDBManager dbManager) throws Throwable {
        if (dbManager.getDBType() != 6) {
            return true;
        }
        PartitionInfo partitionInfo = ((MySqlClusterDBManager)dbManager).getPartitionInfo(this.table.getKey());
        if (!this.table.getPartitionMethod().equals(partitionInfo.getPartitionMethod())) {
            return false;
        }
        return partitionInfo.isPartitionColumnEqual(this.table.getPartitionColumnSet());
    }

    private boolean checkPartition(IDBManager dbManager, MetaSchemaTable table) throws Throwable {
        if (dbManager.getDBType() != 6) {
            return true;
        }
        MySqlClusterDBManager manager = (MySqlClusterDBManager)dbManager;
        PartitionInfo info = manager.getPartitionInfo(table.getKey());
        if (!table.getPartitionMethod().equals(info.getPartitionMethod())) {
            return false;
        }
        return info.isPartitionColumnEqual(table.getPartitionColumnSet());
    }

    public boolean checkTableExist(IDBManager dbManager, String tableName) throws Throwable {
        return dbManager.checkTableExist(tableName);
    }
}

