import "./modulepreload-polyfill-7faf532e.js";
import { E as ERPInit } from "./erp-yes-ui-4313cb43.js";
import { r as regH5Controls, T as Tabs$1 } from "./yes-ui-m-e141a639.js";
import { C as ControlMapping, N as YesOwnerDraw, T as Tabs, R as YesModalContainer, D as Dialog, O as MainContainerBuilder } from "./yes-ui-29852ed4.js";
import { a as MLogin, E as ErrorUtils, T as TabContainerExprHandler, d as TabContainerUIProcess, e as TabContainerBuilder, m as mobilefun } from "./yes-core-m-afcb68d3.js";
import { bo as FallBackUtil, af as ExceptionStack, a_ as MainContainer, R as Request, bt as SvrMgr, c1 as MapSetting, cS as YesCore, bq as InterActiveFactory, c9 as supportTouch, a as ControlType, a3 as FuncMap, F as FormStack, V as ViewContext, bC as CompSetting, b4 as CookiesUtil, aD as AppSetting, cT as RemoteService, I as I18N, d6 as ErrorUtil, d8 as ExprHandlerMap, d9 as CalcMap, C as CompBuilder, aB as SessionParasCache, b7 as SessionInfo, cP as Env, d1 as afterYIUILoad, d2 as UIOptTraceUtil, o as MainUIOptTracer, T as TypeConvertor, m as MetaService, d as MetaForm, Y as FormFactory, y as FormType, O as OperationState, Z as OptQueue, _ as NewOpt, p as FormBuilder, j as FormRender, U as UIScopeTrees, X as DocService, a9 as ConfirmPanelSetting, i as DesignModeSetting } from "./yes-core-73b995f9.js";
import { F as FormDesignContainer } from "./designer-86ac79d5.js";
import "./vendor-dcacb77b.js";
import { S as ShowHelpTxt } from "./erp-yes-core-25f33c37.js";
window["doFormGoBackEvent"] = function() {
  let isBackApp = FallBackUtil.isBackApp();
  if (isBackApp) {
    FallBackUtil.doFallBack();
  }
  return isBackApp;
};
let yigoFontSize = window.getComputedStyle(document.documentElement).getPropertyValue("--yigoFontSize");
if (yigoFontSize) {
  let fontSize = parseFloat(yigoFontSize.replace("px", ""));
  window.YIUI.BaseYigoFontSize = fontSize;
}
window["setHtmlBaseFontSize"] = function(fontScale) {
  let baseFontSize = "12px";
  if (window.YIUI.BaseYigoFontSize) {
    baseFontSize = window.YIUI.BaseYigoFontSize * fontScale + "px";
  } else {
    baseFontSize = 12 * fontScale + "px";
  }
  document.documentElement.style.setProperty("--yigoFontSize", baseFontSize);
};
window.addEventListener("error", function(e) {
  ExceptionStack.push(e.error);
});
window.addEventListener("unhandledrejection", function(e) {
  ExceptionStack.push(e.reason);
});
const mainContainer = MainContainerBuilder(Tabs$1);
MainContainer.set(mainContainer);
Request.mode = 2;
const webRoot = (() => {
  let url;
  if (SvrMgr.baseurl) {
    url = `${SvrMgr.baseurl}/${"yesui-vnode"}/`;
  } else {
    url = `${"yesui-vnode"}/`;
  }
  return url;
})();
(function() {
  var _url = [window.location.protocol, "//", window.location.host, "/"].join("");
  MapSetting.BDUrl = _url + webRoot + "lib/map/bdmap.html";
  MapSetting.GDUrl = _url + webRoot + "lib/map/gdmap.html";
})();
window.YIUI = {
  ...window.YIUI || {},
  YesCore,
  InterActiveFactory,
  MLogin,
  supportTouch,
  BuilderMap: ControlMapping,
  ControlType,
  FuncMap,
  FormStack,
  ViewContext,
  MainContainer,
  CompSetting,
  SvrMgr,
  CookiesUtil,
  webRoot,
  AppSetting,
  RemoteService,
  YesOwnerDraw,
  Expr: FuncMap,
  I18N,
  ErrorUtil
};
ErrorUtils.LoginInfo();
ExprHandlerMap.reg(ControlType.CONTAINER, TabContainerExprHandler);
CalcMap.reg(ControlType.CONTAINER, TabContainerUIProcess);
CompBuilder.reg(ControlType.CONTAINER, new TabContainerBuilder());
FuncMap.regCluster(mobilefun);
SvrMgr.getSessionInfo().then(function(result) {
  if (result) {
    if (result.SessionParas) {
      var sessionData = result.SessionParas;
      if (typeof sessionData === "string") {
        sessionData = JSON.parse(sessionData);
      }
      SessionParasCache.setParas(sessionData);
    }
    SessionInfo.setCode(result.Code);
    SessionInfo.setUserName(result.Name);
    SessionInfo.setUserID(result.UserID);
    SessionInfo.setClusterID(result.clusterID);
    SessionInfo.setLoginTime(result.Time);
  } else {
    SessionInfo.clear();
  }
}).finally(async () => {
  await new RemoteService().getMobileEnvDef().then(function(mobileInfo) {
    let { MetaFormAliasKeys, MetaMobileDef } = mobileInfo;
    Env.setAliasKeyMap(MetaFormAliasKeys);
    if (MetaMobileDef && MetaMobileDef["eventDefCollection"]) {
      Env.setEventDefCollection(MetaMobileDef["eventDefCollection"]);
    }
  }).catch(function(e) {
    throw e;
  });
  await SvrMgr.checkSession().then(function(result) {
    if (result) {
      startForm();
    } else {
      SvrMgr.touristLogin().then(() => {
        startForm();
      });
    }
  });
  ERPInit.init();
  afterYIUILoad();
  await UIOptTraceUtil.init();
  window.YIUI.MainUIOptTracer = MainUIOptTracer;
  function repeatUploadUIOptTraces() {
    UIOptTraceUtil.uploadTraces();
    setTimeout(repeatUploadUIOptTraces, 3e5);
  }
  repeatUploadUIOptTraces();
});
let startForm = function() {
  var _a;
  let inDesigning = false, fileFormPath = "", designFormKey;
  if (parent) {
    var p_formkey = window.YIUI.getURLParas().formKey;
    var p_isDesignMode = TypeConvertor.toBoolean(window.YIUI.getURLParas().isDesignMode);
    if (p_isDesignMode && p_formkey) {
      designFormKey = p_formkey;
      inDesigning = true;
      fileFormPath = window.YIUI.getURLParas().fileFormPath;
      (_a = document.getElementById("app")) == null ? void 0 : _a.classList.add("designingForm");
      new Tabs({
        parent: window.document.createElement("div")
      });
    }
  }
  SvrMgr.getStartForm().then((res) => {
    let { startForm: startForm2 = "", loginForm = "" } = {};
    if (!inDesigning && !res) {
      throw Error("未定义启动项，请配置中定义后重试");
    }
    if (res) {
      startForm2 = res.startForm;
      loginForm = res.loginForm;
    }
    if (designFormKey) {
      startForm2 = designFormKey;
    }
    MLogin.setLoginForm(loginForm, startForm2);
    let metaService = new MetaService();
    return metaService.getMetaForm(startForm2).then((meta) => {
      var metaForm = new MetaForm(meta);
      let appEnv = null;
      var emptyForm = FormFactory.create(metaForm, appEnv);
      if ((emptyForm["type"] == FormType.ENTITY || emptyForm["type"] == FormType.DICT) && emptyForm["metaForm"].initState == OperationState.NEW) {
        emptyForm.setOptQueue(new OptQueue(new NewOpt(emptyForm)));
      }
      emptyForm.fileFormPath = fileFormPath;
      emptyForm.setPara("MobileFormPath", fileFormPath);
      emptyForm.setPara("OwnerFormKey", window.YIUI.getURLParas().ownerFormKey);
      return emptyForm.calcCaption().then(function() {
        var builder = new FormBuilder(metaForm.key);
        builder.setContainer(MainContainer);
        return builder.build(emptyForm).finally(() => {
          if (inDesigning) {
            doAfterFormBuild(emptyForm);
          }
          window.removeLoadingView && window.removeLoadingView();
        });
      });
    });
  }).finally(async () => {
    if (!inDesigning) {
      await doAddressLink();
    }
    startForm = function() {
    };
    doAddressLink = function() {
    };
    displayByShareForm = function() {
    };
  });
};
let doAfterFormBuild = function(emptyForm) {
  Tabs.getInstance({}).currentFormID = emptyForm.formID;
  window.FormDesignContainer = new FormDesignContainer();
  window.FormDesignContainer.setParentWindow(window.parent);
  let formKey = emptyForm.getFormKey();
  if (emptyForm.getMetaForm().extensionFormKey) {
    formKey = emptyForm.getMetaForm().extensionFormKey;
  }
  window.parent.FormDesignEnvironment.addContentWindow(formKey, window);
  window.FormDesignContainer.afterBuildActiveForm(formKey);
};
let doAddressLink = function() {
  var query = window.location.search.substring(1);
  if (query) {
    var callurl = "", callArr = [], paraJson = {};
    var vars = query.split("&");
    for (var i = 0; i < vars.length; i++) {
      var pair = vars[i].split("=");
      if (pair[0] == "link") {
        callurl = pair[1] + "?";
      } else {
        callArr.push(vars[i]);
        paraJson[pair[0]] = pair[1];
      }
    }
    callurl = callurl + callArr.join("&");
    if (paraJson["formKey"]) {
      displayByShareForm(JSON.stringify(paraJson));
    }
  }
};
let displayByShareForm = function(paraJson) {
  var paras = JSON.parse(paraJson);
  var formList = FormStack.getFormList();
  if (!formList)
    return;
  var form = formList[formList.length - 1];
  var cxt = new ViewContext(form);
  var formula = "Show('" + paras.formKey + "')";
  if (paras.oid > 0) {
    formula = "Open('" + paras.formKey + "'," + paras.oid + ")";
  }
  return form.asyncEval(formula, cxt);
};
regH5Controls();
FormRender.setYesCom(new YesModalContainer());
MLogin.setContainer(MainContainer);
window.BaseFunsExt = {
  ShowHelpTxt
};
ConfirmPanelSetting.confirmPanelSize = "70% 168";
window.Svr = window.Svr || {};
window.Svr.Request = Request;
window.UIScopeTrees = UIScopeTrees;
window.YIUI.DocServiceExt = DocService;
window.YIUI.Dialog = Dialog;
AppSetting.updateClientSetting("yescore.component.base.CompStyle", "innerLabel_m");
AppSetting.updateClientSetting("yescore.component.grid.restoreInitStatus", true);
window.View = { FuncMap: null };
window.Expr = {
  regCluster: function(map, funext) {
    FuncMap.regCluster(funext);
  }
};
window.YIUI.isShowReloadButton = true;
window.YIUI.getURLParas = function() {
  var params = {};
  var paramArr = decodeURIComponent(window.location.search).substring(1).split("&");
  for (var index in paramArr) {
    var itemArr = paramArr[index].split("=");
    if (itemArr.length == 2)
      params[itemArr[0]] = itemArr[1];
  }
  return params;
};
Object.defineProperty(window.YIUI, "confirmPanelSize", {
  get: function() {
    return ConfirmPanelSetting.confirmPanelSize;
  },
  set: function(value) {
    ConfirmPanelSetting.confirmPanelSize = value;
  }
});
DesignModeSetting.addDesignerProjects(ERPDESIGNER.PROJECTKEY_WEBCONFIG, window.ERPDESIGNER.PROJECTKEY_BPMN);
DesignModeSetting.setDesignMode(window.YIUI.getURLParas().isDesignMode == "true");
new Tabs$1({
  parent: document.querySelector("#app")
});
//# sourceMappingURL=m_home-cd85500e.js.map
