(async () => {
    let { ExtendedFieldsParas } = await import("../../ux/extended-fields/fieldparas.js");
    let { GetLangSetting, setI18N } = await import("../../utils/utils.js");
    var needLoginCheck = true;
    var isDev;
    window.addEventListener("YIUI-loaded", e => {
        isDev = YIUI.AppSetting.isDev;

        if (isDev) {
            history.pushState({}, "", location.origin + location.search + location.hash);
        }
    });

    window.addEventListener("YES-APP-Login-page-loaded", async () => {
        const { uxInit } = await import("../../ux/load-ux.js");
        await uxInit();

        document.querySelector('.login-main').style.display = 'flex';
        document.querySelector('.waitting-box').style.display = 'none';
    });

    const oLoginbox = document.querySelector(".login-loginbox"),
        oLoginOrgCode = document.querySelector(".login-orgcode"),
        oUsername = document.querySelector(".login-username"),
        oPassword = document.querySelector(".login-password"),
        oShowSwitch = document.querySelector(".show-switch"),
        oLoginBtn = document.querySelector(".login-button"),
        oLoginOrgCombox = document.querySelector(".login_org"),
        oLoginOrgInfo = document.querySelector(".login_org-info");
    const oLocale = document.querySelector(".login_locale");
    const oLocaleInfo = document.querySelector(".login_locale-info");
    const oValid = document.querySelector(".login-valid-rows");
    const oValidInfo = document.querySelector(".login-valid-info");
    //oUsername.focus();

    const initLoginInfo = () => {
        var lastorgcode = YIUI.CookiesUtil.get("login_orgcode") || '000';
        var lastusername = YIUI.CookiesUtil.get("login_username") || '';
        oLoginOrgCode.value = lastorgcode;
        oUsername.value = lastusername;
        if (!lastorgcode) {
            oLoginOrgCode.focus();
        } else if (!lastusername) {
            oUsername.focus();
        } else {
            oPassword.focus();
        }
    }

    let def;
    loadRely(async () => {
        def = await YIUI.SvrMgr.getLoginDef();
        await Promise.all([
            setLanguage(def),
            setValid(def),
        ]);
        setSession(def);
        window.dispatchEvent(new CustomEvent("YES-APP-Login-page-loaded"));
        initLoginInfo();
    })

    function loadRely(readyCallback) {
        window.addEventListener("YIUI-loaded", e => {
            readyCallback();
        });
    }
    const setSession = (def) => {
        if (!def || !(def.sessionPara || def.paras)) {
            oLoginOrgInfo.remove();
            oLoginOrgCombox.remove();
            return;
        };
        const oName = oLoginOrgCombox.querySelector(".login-combox-name");

        if (def.paras) {
            var paras = def.paras;
            for (var i = 0, p; (p = paras[i]); i++) {
                oLoginOrgCombox.setAttribute("para-key", p.paraKey);
                oLoginOrgCombox.setAttribute("provider", p.provider);
                oName.innerHTML = p.paraTitle || "组织机构";
            }
        } else {
            oLoginOrgCombox.setAttribute("para-key", def.sessionParaKey || "orgID");
            oLoginOrgCombox.setAttribute("provider", def.provider);
            oName.innerHTML = def.sessionParaTitle || "组织机构";

        }
        addEvent(oLoginOrgCombox);

        function addEvent(container) {
            var oVw = container.querySelector(".login_sel_vw");
            container
                .querySelector(".login_paras")
                .addEventListener("click", function (e) {
                    slideToggle(oVw);
                    e.stopPropagation();
                });
        }
        oLoginOrgInfo.style.display = "flex";
        oLoginOrgCombox.style.display = "flex";
    };

    function slideToggle(node) {
        let isShow = getComputedStyle(node).display !== "none",
            fn = () => node.style.display = "none";

        if (isShow) {
            node.style.display = "none";
            document.removeEventListener("click", fn);
        } else {
            node.style.display = "block";
            document.addEventListener("click", fn);
        }
    }

    const setLanguage = async (def) => {
        // 设置默认语言"zh-CN"在cookie,防止如果没有配置语言选项，后台拿不到语言导致报错
        YIUI.CookiesUtil.set("locale", "zh-CN", isDev ? '/' : '', 3650);
        if (!def || !def.multiLang) {
            oLocaleInfo.remove();
            oLocale.remove();
            return
        }
        const supportLang = await YIUI.SvrMgr.getSupportLang();
        let supportLangItems = supportLang?.items || [];
        let items = [];

        // 获取UX配置语言相关内容
        let languageSetting = GetLangSetting("language");
        let settingItems = languageSetting?.comboboxSetting?.items || [];
        let languageDefaultValue = languageSetting?.defaultValue;
        if (settingItems.length > 0) {
            settingItems.forEach(item => {
                const supportLangItem = supportLangItems.find(settingItem => settingItem.value === item.value);
                if (supportLangItem) {
                    items.push(supportLangItem);
                }
            });
        } else {
            items = supportLangItems;
        }
        const oUl = oLocale.querySelector(".locale-combox-list");

        if (!supportLang || !items || !items.length) {
            oLocaleInfo.remove();
            oLocale.remove();
            return
        };
        // 处理UX配置默认值时显示
        const language = setLang(items, languageDefaultValue);
        const oParas = oLocale.querySelector(".locale_paras");
        const oVw = oLocale.querySelector(".login_locale_vw");
        const oLocaleContent = oLocale.querySelector(".locale-combox-content");
        const oLocaleVal = oParas.querySelector(".locale-combox-value");

        const _doSetLang = (lang, caption) => {
            oLocaleVal.setAttribute("value", lang);
            oLocaleVal.innerHTML = caption;
            oLocaleContent.classList.add('select');
            setLocaleToCookie(lang);
        }
        items.forEach((item) => {
            addLangItem(item);
            // 注销后显示上次登录语言
            if (item.value === language) {
                _doSetLang(item.value, item.caption);
            }
        });

        // 若 Cookies 的 locale 拿不到，navigator.language 也拿不到，或者拿到了但是 (supportLang)items 里不包含, 则默认取 items[0] 作为默认语言
        if (!oLocaleVal.getAttribute("value") && items.length > 0) {
            _doSetLang(items[0].value, items[0].caption);
        }

        const docClickHandle = () => {
            oVw.style.display = "none";
            document.removeEventListener("click", docClickHandle);
        };

        oParas.addEventListener("click", (e) => {
            slideToggle(oVw);
            e.stopPropagation();
        });

        oVw.addEventListener("click", async function (e) {
            var e = e || window.event,
                target = e.target.closest('li');
            if (!target) return;
            if (target.classList.contains("sel")) return false;
            var sel = oVw.querySelector(".sel");
            sel && sel.classList.remove("sel");
            target.classList.add("sel");
            const caption = target.innerHTML,
                value = target.getAttribute("value");

            await setLocaleToCookie(value);
            oLocaleVal.setAttribute("value", value);
            oLocaleVal.innerHTML = caption;
            oVw.style.display = "none";
            e.stopPropagation();
            e.preventDefault();
        });

        function addLangItem(item) {
            const { value, caption } = item,
                oLi = document.createElement("li");
            oLi.setAttribute("value", value);
            oLi.classList.add("login-combox-item");

            if (value === language) {
                oLi.classList.add("sel");
            }

            oLi.innerHTML = caption;
            oUl.appendChild(oLi);
        }

        function setLang(supportLangs, languageDefaultValue) {
            let origLocale = YIUI.CookiesUtil.get("locale");
            let locale = origLocale;
            if (!locale) {
                // navigator.language || navigator.userLanguage  在浏览器中，可能会出现en，zh，没有-的情况，如果出现这种情况后台会报错默认中文"zh-CN"
                locale = languageDefaultValue || "zh-CN";
                if (locale.includes("-")) {
                    locale = locale.toLowerCase();
                    const idx = locale.indexOf("-");
                    locale =
                        locale.substring(0, idx) +
                        "-" +
                        locale.substring(idx + 1).toUpperCase();
                }
            }

            // 如果实时获取到的 language (比如 "zh" ) 不在 supportLang 语言列表里, 则直接给其赋值为 "zh-CN"
            if (!supportLangs.some(i => i.value === locale)) {
                locale = "zh-CN";
            }
            if (origLocale != locale) {
                YIUI.CookiesUtil.set("locale", locale, isDev ? '/' : '', 3650);
                if (languageDefaultValue) {
                    setI18N();
                }
            }

            return locale;
        }

        oLocale.style.display = "flex";
        oLocaleInfo.style.display = "flex";
    };

    async function refreshValidateCode() {
        const oImg = oValid.querySelector(".login_valid_img");
        let id = YIUI.CookiesUtil.get("tmpClientID");
        if (!id) {
            id = await YIUI.SvrMgr.getTmpClientID();
            YIUI.CookiesUtil.set("tmpClientID", id);
        }
        const { result } = await YIUI.SvrMgr.validateImage({ tmpclientid: id });
        oImg.setAttribute("src", "data:image/png;base64," + result);
        document.querySelector(".login-valid").value = '';
    }

    const setValid = (def) => {
        if (!def || !def.valid) {
            oLoginbox.classList.remove('has-valid');
            oValid.remove();
            oValidInfo.remove();
            return;
        }
        oLoginbox.classList.add('has-valid');
        // oValid.show();
        const oImg = oValid.querySelector(".login_valid_img");
        if (def.validateCode) {
            oImg.setAttribute("src", "data:image/png;base64," + result);
            oValid.style.display = "block";
            oValidInfo.style.display = "block";
        } else {
            refreshValidateCode().then(() => {
                oValid.style.display = "block";
                oValidInfo.style.display = "block";
            });
        }
        oImg.addEventListener("click", refreshValidateCode);

    };

    const getValidateCode = () =>
        def && def.valid
            ? document.querySelector(".login-valid").value
            : "";
    oLoginBtn.addEventListener("click", function () {
        var username = oUsername.value;
        var password = document.querySelector(".login-password").value;
        var validateCode = getValidateCode();
        var tmpClientID = YIUI.CookiesUtil.get("tmpClientID");

        var orgcode = oLoginOrgCode.value;
        var loginname = username;
        let extendedFieldsParas = ExtendedFieldsParas.getExtendedFieldsParas();
        const sessionParas = { OrgCode: orgcode, ...extendedFieldsParas };
        doLoginCheck(loginname, password, sessionParas, validateCode, tmpClientID).then((result) => {
            var sessionInfo = result && result.SessionInfo;
            var kick = result && result.kick;
            if (kick && sessionInfo && sessionInfo[0]) {
                var info = sessionInfo[0];
                var ips = info.IP;
                var len = sessionInfo.length;
                if (len > 1) {
                    for (let i = 0; i < len; i++) {
                        ips += (" ;" + sessionInfo[i].IP)
                    }
                }
                var content = '<div id="formEdit" class="login-check-content">'
                    + '<div class="normal">' + YIUI.I18N.getString("", "用户") + ' ' + YIUI.I18N.getString("", username) + '已经在客户端 ' + location.port + '登录</div>'
                    + '<div class="normal">IP ：' + ips + '</div>'
                    + '<div class="normal">登录时间 ：' + YIUI.DateFormat.format(new Date(info.loginTime), 'yyyy-MM-dd HH:mm:ss') + '</div>'
                    + '<div class="normal">最后活动时间 ：' + YIUI.DateFormat.format(new Date(info.lastActiveTime), 'yyyy-MM-dd HH:mm:ss') + '</div>'
                    + '<div class="error">是否下线其他设备登录？</div>';
                + '</div>'

                let options = {};
                options.headerTitle = YIUI.I18N.getString("", "多次登录信息");
                options.showText = false;
                options.msg = content;
                options.msgType = 2;
                options.className = { 'panel': 'login-check' };
                options.panelSize = "516 261";
                let dialog = YIUI.DialogFactory.create(options);
                return dialog.show();
            }
            return Promise.resolve();
        }).then((result) => {
            if (result == 'Cancel') {
                return;
            }
            var loginSessionParas = Object.assign({}, sessionParas, result && { kick: result == 'YES' });
            return YIUI.SvrMgr.doLogin(loginname, password, loginSessionParas, validateCode, tmpClientID).then((ret) => {
                if (ret) {
                    return doPasswordRetryConform(ret.LoginCount).then(() => {
                        YIUI.CookiesUtil.set("login_orgcode", orgcode);
                        YIUI.CookiesUtil.set("login_username", username);
                        //跳转
                        location.href = location.href.replace("login.html", "");
                    });
                }
            });
        }).catch((err) => {
            def && def.valid && refreshValidateCode()
            const allErrorSpans = document.querySelectorAll(".login-info.error span");
            for (let i = 0; i < allErrorSpans.length; i++) {
                const tmpSpan = allErrorSpans[i];
                tmpSpan.innerText = '';
            }
            const message = YIUI.ErrorUtil.getErrorMessage(err);
            let selector = '.login-other-info span';
            if (message.code && (message.code === -2146828280 || message.code === -2146828287)) {
                selector = ".login-info" + message.code + " span";
            }
            const errorText = message.message ? message.message : message;
            const errorSpan = document.querySelector(selector);
            errorSpan && (errorSpan.innerText = errorText);
        });
    });
    const doEnterEvent = (e, node) => {
        e.stopPropagation();
        var keyCode = e.keyCode;
        //回车跳到下一个字段
        if (keyCode !== 13) {
            return;
        }
        var tabIndex = node.tabIndex;
        if (!tabIndex || tabIndex < 0) {
            return;
        }
        var els = document.querySelectorAll('.login-strip input[tabindex]');
        if (!els || els.length < 0) {
            return;
        }
        var el;
        for (let index = 0; index < els.length; index++) {
            const value = els[index];
            var i = value.tabIndex;
            if (i > tabIndex) {
                el = value;
                break;
            }
        }
        node.blur();
        if (el) {
            el.focus();
        } else {
            oLoginBtn.click();
        }
    }
    document.querySelectorAll("input").forEach((node) => {
        node.addEventListener("keyup", (e) => {
            if (e.keyCode == 13) {
                doEnterEvent(e, node);
            }
        });
    });

    async function setLocaleToCookie(val) {
        if (YIUI.CookiesUtil.get("locale") !== val) {
            YIUI.CookiesUtil.set("locale", val, isDev ? '/' : '', 3650);
            await setI18N();
        }
    }

    function doLoginCheck(username, password, sessionPara, validateCode, tmpClientID, mode) {
        var request = new YIUI.Request();
        if (!needLoginCheck) {
            return Promise.resolve();
        }
        return YIUI.SvrMgr.getPublicKey().then(function (publicKey) {
            var loginInfo = {};
            loginInfo.user = username;
            loginInfo.password = password;
            loginInfo.validatecode = validateCode;
            loginInfo.mode = mode || 1;

            var str1 = JSON.stringify(loginInfo);
            var data = YIUI.RSAUtil.encrypt_b64(publicKey, str1);
            var opts = {
                logininfo: data,
                tmpclientid: tmpClientID || "",
                paras: JSON.stringify(sessionPara || {}),
                cmd: "LoginCheck",
                service: "Authenticate",
            };
            return request.getData(opts).then(function (result) {
                return result || false;
            });
        });
    }


    function doPasswordRetryConform(loginCount) {
        if (!needLoginCheck || !loginCount || loginCount <= 0) {
            return Promise.resolve('OK');
        }
        let options = {};
        options.headerTitle = YIUI.I18N.getString("", "信息");
        options.msg = '密码登录尝试次数：' + loginCount + '次';
        options.msgType = 0;
        options.className = { 'panel': 'login-check ' };
        options.panelSize = "417 261";
        let dialog = YIUI.DialogFactory.create(options);
        return dialog.show();
    }


    //密码显示
    oShowSwitch.addEventListener("click", function (event) {
        event.preventDefault();
        oShowSwitch.classList.toggle('closed');
        oPassword.setAttribute("type", oShowSwitch.classList.contains("closed") ? "password" : "text");
    });
})();
