var _a;
import { F as FormStack, l as Utils, W as FormTarget, cx as getEntryData } from "./yes-core-73b995f9.js";
import { N as interact } from "./vendor-dcacb77b.js";
import { W as YesUI, X as openFormByTreeClick } from "./yes-ui-29852ed4.js";
const rightSlideDrawer = "";
const _getRightSlideDrawerSize = () => {
  return {
    minWidth: 400,
    maxWidth: window.innerWidth,
    minHeight: window.innerHeight * 0.5,
    maxHeight: window.innerHeight
  };
};
class RightSlideDrawer {
  /**
   * RightSlideDrawer 构造函数
   * @param {string} formKey 表单标识
   * @param {number} OID 选项 ID
   * @param {Object} options 表单选项
   * @param {SizeOptions} sizeOptions 尺寸参数
   */
  constructor(formKey, OID, options, sizeOptions) {
    const $container = document.querySelector(".drawer-container." + formKey);
    if ($container) {
      this.$container = $container;
    } else {
      this.createHTML(formKey, sizeOptions);
      this.install(sizeOptions);
      const myOptions = Object.assign(options || {}, { formKey, OID });
      YesUI.Forms.buildForm(myOptions, this.$drawerInner).then((form) => {
        form && form.doOnLoad();
      });
    }
    this.show();
    this._initRightSlideDrawerSize(formKey, sizeOptions);
    (sizeOptions == null ? void 0 : sizeOptions.resizable) && this._initResizeListener(formKey);
    window.addEventListener("resize", this._windowResizeListener.bind(this));
  }
  createHTML(formKey, sizeOptions) {
    this.$container = document.createElement("div");
    this.$container.classList.add("drawer-container");
    formKey && this.$container.classList.add(formKey);
    this.$drawer = document.createElement("div");
    this.$drawer.classList.add("drawer");
    this.$drawerInner = document.createElement("div");
    this.$drawerInner.classList.add("drawer-inner");
    this.$drawer.appendChild(this.$drawerInner);
    this.$container.appendChild(this.$drawer);
    document.body.appendChild(this.$container);
    if (sizeOptions == null ? void 0 : sizeOptions.showClose) {
      const closeButton = document.createElement("span");
      closeButton.classList.add("drawer-closeBtn");
      closeButton.setAttribute("title", "关闭");
      closeButton.addEventListener("click", (e) => {
        const form = FormStack.getActiveForm();
        form && this.close(form);
        e.stopPropagation();
      });
      this.$drawer.appendChild(closeButton);
    }
  }
  install(sizeOptions) {
    this.$drawerInner.close = this.close.bind(this);
    this.$drawer.addEventListener("click", (e) => e.stopPropagation());
    if (sizeOptions == null ? void 0 : sizeOptions.showClose) {
      return;
    }
    this.$container.addEventListener("click", (e) => {
      const form = FormStack.getActiveForm();
      form && this.close(form);
      e.stopPropagation();
    });
  }
  getContainer() {
    return this.$drawerInner;
  }
  show() {
    this.$container.classList.add("show");
  }
  hide() {
    this.$container.classList.remove("show");
  }
  close(form) {
    form.unlock && form.unlock();
    const onClose = form.onClose;
    if (typeof onClose === "function") {
      onClose.call(form);
    } else if (onClose) {
      form.asyncEval(onClose);
    }
    this.getContainer().removeForm(form);
    this.$container.remove();
    window.removeEventListener("resize", this._windowResizeListener.bind(this));
  }
  /**
   * 初始化调整大小
   * @param formKey 表单标识
   * @param sizeOptions 尺寸参数
   */
  _initRightSlideDrawerSize(formKey, sizeOptions) {
    const rightSlideDrawerSize = Utils.getCookie(`rightSlideContainer-${formKey}-size`);
    if (rightSlideDrawerSize) {
      const [width2, height2] = rightSlideDrawerSize.split(",");
      this.$drawer.style.width = `${width2}px`;
      this.$drawer.style.height = `${height2}px`;
    } else {
      const [width2, height2] = (sizeOptions == null ? void 0 : sizeOptions.size) || ["", ""];
      this.$drawer.style.width = width2 || "400px";
      this.$drawer.style.height = height2 || "100%";
    }
    const { minWidth, maxWidth, minHeight, maxHeight } = _getRightSlideDrawerSize();
    const { width, height } = window.getComputedStyle(this.$drawer);
    this.$drawer.style.width = Math.min(Math.max(parseFloat(width), minWidth), maxWidth).toString() + "px";
    this.$drawer.style.height = Math.min(Math.max(parseFloat(height), minHeight), maxHeight).toString() + "px";
  }
  // 初始化可调整大小的事件监听器
  _initResizeListener(formKey) {
    const { minWidth, maxWidth, minHeight, maxHeight } = _getRightSlideDrawerSize();
    interact(this.$drawer).resizable({
      edges: { left: true, bottom: true },
      inertia: false,
      modifiers: [
        interact.modifiers.restrictEdges({
          outer: "parent"
        }),
        interact.modifiers.restrictSize({
          min: { width: minWidth, height: minHeight },
          max: { width: maxWidth, height: maxHeight }
        })
      ],
      listeners: {
        move(event) {
          const target = event.target;
          target.style.width = `${event.rect.width}px`;
          target.style.height = `${event.rect.height}px`;
        },
        end(event) {
          Utils.setCookie(
            `rightSlideContainer-${formKey}-size`,
            `${event.rect.width.toFixed(3)},${event.rect.height.toFixed(3)}`
          );
        }
      }
    }).on("mousedown", (event) => {
      if (event.target === event.currentTarget) {
        this.$drawer.classList.add("resizing");
      }
    }).on("mouseup", (event) => {
      if (event.target === event.currentTarget) {
        this.$drawer.classList.remove("resizing");
      }
    });
  }
  /**
   * 窗口调整大小监听器
   * 用于在窗口大小变化时调整 RightSlideDrawer 的尺寸
   */
  _windowResizeListener() {
    const { width, height } = window.getComputedStyle(this.$drawer);
    if (window.innerHeight - parseFloat(height) < 8) {
      this.$drawer.style.height = "100%";
    }
    if (window.innerWidth - parseFloat(width) < 8) {
      this.$drawer.style.width = "100%";
    }
    this.$drawer.classList.contains("resizing") && this.$drawer.classList.remove("resizing");
  }
}
let navContainer, leftSideContainer, leftNav, centerNav, rightNav;
if (((_a = document.querySelector("html")) == null ? void 0 : _a.getAttribute("data-page")) === "mainframe") {
  navContainer = document.querySelector(".nav");
  leftSideContainer = document.querySelector(".mainLeft");
  leftNav = navContainer == null ? void 0 : navContainer.querySelector(".nav-left");
  centerNav = navContainer == null ? void 0 : navContainer.querySelector(".nav-center");
  rightNav = navContainer == null ? void 0 : navContainer.querySelector(".nav-right");
}
const _prependTo = (newElm, referenceElm) => {
  let firstChild = referenceElm.firstChild;
  if (firstChild) {
    referenceElm.insertBefore(newElm, firstChild);
  } else {
    referenceElm.appendChild(newElm);
  }
};
const _appendDom = (container, dom, position) => {
  if (position && position === "before") {
    _prependTo(dom, container);
    return;
  }
  container.appendChild(dom);
};
const _openFormByFormRender = async (options) => {
  return await YesUI.Forms.buildForm(options);
};
let _leftSideToggleListenerCallback;
window.addEventListener("YES-MainFrame-leftSideToggle", (e) => {
  _leftSideToggleListenerCallback && _leftSideToggleListenerCallback(e.detail.leftSideStatus);
}, false);
let _leftSideResizeListenerCallback;
window.addEventListener("YES-MainFrame-leftSideResize", (e) => {
  _leftSideResizeListenerCallback && _leftSideResizeListenerCallback(e.detail.leftSideWidth);
}, false);
let _entryReloadListenerCallback;
window.addEventListener("YES-MainFrame-entryReload", (e) => {
  _entryReloadListenerCallback && _entryReloadListenerCallback(e.detail.entryData);
}, false);
class MainFrame {
  /**
   * 显示 leftSide
  */
  static showLeftSide() {
    leftSideContainer && (leftSideContainer.style.display = "block");
  }
  /**
   * 隐藏 leftSide
  */
  static hideLeftSide() {
    leftSideContainer && (leftSideContainer.style.display = "none");
  }
  /**
  * 监听 leftSide 展开收起
  */
  static leftSideToggleListener(callback) {
    _leftSideToggleListenerCallback = callback;
  }
  /**
  * 监听 leftSide 宽度变化
  */
  static leftSideResizeListener(callback) {
    _leftSideResizeListenerCallback = callback;
  }
  /**
  * 主动触发 entryReload entry 菜单重新加载
  */
  static entryReload() {
    window.dispatchEvent(new CustomEvent("YES-MainFrame-callEntryReload"));
  }
  /**
  * 监听 entryReload
  */
  static entryReloadListener(callback) {
    _entryReloadListenerCallback = callback;
  }
  /**
   * append 一个区域到 leftSide body
   * @param {HTMLElement} dom
   * @param {String} position before | after， 默认是 after
  */
  static appendDomToLeftSide(dom, position) {
    leftSideContainer && _appendDom(leftSideContainer, dom, position);
  }
  /**
   * 在 nav-right 内部插入节点
   * @param {HTMLElement} dom
   * @param {String} position before | after， 默认是 after
  */
  static appendDomToRightNav(dom, position) {
    rightNav && _appendDom(rightNav, dom, position);
  }
  /**
   * 在 nav-left 内部插入节点
   * @param {HTMLElement} dom
   * @param {String} position before | after， 默认是 after
  */
  static appendDomToLeftNav(dom, position) {
    leftNav && _appendDom(leftNav, dom, position);
  }
  /**
   * 在 nav-center 内部插入节点
   * @param {HTMLElement} dom
   * @param {String} position before | after， 默认是 after
  */
  static appendDomToCenterNav(dom, position) {
    centerNav && _appendDom(centerNav, dom, position);
  }
  /**
   * 设置 Instance Tag 右上角的当前系统性质，比如开发版DEV）
   * @param {HTMLElement} dom
  */
  static setInstanceTag(dom) {
    this.appendDomToRightNav(dom);
  }
  /**
   * 添加 user 菜单 Action
   * @param {Object} navAction 格式参照 window.YigoClientPageVariable.YigoClassicUxSetting.avaliableNavActions
  */
  static addUserNavAction(navAction) {
    navAction && window.dispatchEvent(new CustomEvent("YES-MainFrame-addUserAction", {
      detail: { navAction }
    }));
  }
  /**
   * 添加 setting 菜单 Action
   * @param {Object} navAction 格式参照 window.YigoClientPageVariable.YigoClassicUxSetting.avaliableNavActions
  */
  static addSettingNavAction(navAction) {
    navAction && window.dispatchEvent(new CustomEvent("YES-MainFrame-addSettingAction", {
      detail: { navAction }
    }));
  }
  /**
   * 在 RightSlideDrawer 中显示 yigo 表单
   * @param {String} formKey 必填写
   * @param {Number} OID， OID 默认为 -1
   * @param {Object} options {parameters, target, ...}
   * @param {Object} sizeOptions 尺寸参数 { size, resizable }
  */
  static openFormInRightSlide(formKey, OID = -1, options = {}, sizeOptions = {}) {
    new RightSlideDrawer(formKey, OID, options, sizeOptions);
  }
  /**
   * 在 Dialog 中显示 yigo 表单
   * @param {String} formKey 必填写
   * @param {Number} OID， OID 默认为 -1
   * @param {object} options {parameters, target, ...}
   * @param {boolean} 是否仅显示
  */
  static async openFormInDialog(formKey, OID = -1, options = {}) {
    return await _openFormByFormRender({ ...options, formKey, OID, target: FormTarget.MODAL });
  }
  /**
   * 在 newTab 中显示 yigo 表单
   * @param {String} formKey 必填写
   * @param {Number} OID， OID 默认为 -1
   * @param {object} options {parameters, target, ...}
  */
  static openFormInNewTab(formKey, OID = -1, options = {}) {
    return _openFormByFormRender({ ...options, formKey, OID, target: FormTarget.NEWTAB });
  }
  /**
   * 通过 entryPath 打开 yigo 表单 (默认 NewTab)
   * @param {String} entryPath 必填写
  */
  static openFormByEntryPath(entryPath) {
    openFormByTreeClick("entryPath", entryPath);
  }
  /**
   * 通过 entryKey 打开 yigo 表单 (默认 NewTab)
   * @param {String} entryKey 必填写
  */
  static openFormByEntryKey(entryKey) {
    openFormByTreeClick("entryKey", entryKey);
  }
}
MainFrame.getEntryData = getEntryData;
export {
  MainFrame as M
};
//# sourceMappingURL=index-95bcd4da.js.map
