/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.EntityUtil;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;

public class EntityArrayList<E extends AbstractTableEntity>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<E> inner;
    private final RichDocumentContext context;
    private final AbstractBillEntity parent;
    private final String tableKey;
    private final Map<Long, E> map;
    private final Class<E> clz;
    private final DataTable curRst;
    private DataTable dataTable;
    private List<E> filterList;
    private final Map<String, Object> filterFieldValues;
    private int[] rowIndexes;
    private boolean init = false;

    public EntityArrayList(RichDocumentContext context, AbstractBillEntity parent, String tableKey, Class<E> clz, Map<Long, E> map) {
        this.context = context;
        this.parent = parent;
        this.tableKey = tableKey;
        this.clz = clz;
        this.map = map;
        this.curRst = parent.document.get_impl(tableKey);
        this.filterFieldValues = null;
        this.init = false;
    }

    public EntityArrayList(List<E> list) {
        this.context = null;
        this.parent = null;
        this.tableKey = null;
        this.clz = null;
        this.map = null;
        this.curRst = null;
        this.inner = list;
        this.filterFieldValues = null;
        this.init = true;
    }

    public EntityArrayList(List<E> list, Map<String, Object> filterFieldValues) throws Throwable {
        this.context = null;
        this.parent = null;
        this.tableKey = null;
        this.clz = null;
        this.map = null;
        this.curRst = null;
        this.inner = null;
        this.filterList = list;
        this.filterFieldValues = filterFieldValues;
        if (list.size() > 0) {
            this.dataTable = ((AbstractTableEntity)list.get(0)).getDataTable();
        } else if (list instanceof EntityArrayList) {
            EntityArrayList tmp = (EntityArrayList)list;
            this.dataTable = tmp.curRst;
        }
        Set<Map.Entry<String, Object>> entrySet = filterFieldValues.entrySet();
        int fieldCount = entrySet.size();
        String[] filterKeys = new String[fieldCount];
        Object[] filterValues = new Object[fieldCount];
        int i = 0;
        for (Map.Entry<String, Object> entry : filterFieldValues.entrySet()) {
            filterKeys[i] = entry.getKey();
            filterValues[i] = entry.getValue();
            ++i;
        }
        this.rowIndexes = this.dataTable.fastFilter(filterKeys, filterValues);
        this.init = false;
    }

    public void initAll() {
        if (this.init) {
            return;
        }
        if (this.rowIndexes != null) {
            try {
                this.init_filter(this.rowIndexes.length);
            }
            catch (Throwable e) {
                LogSvr.getInstance().error(e.getMessage(), e);
                throw new RuntimeException("EntityArrayList\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\uff01");
            }
        } else if (this.curRst != null) {
            this.init_DataTable(this.curRst.size() - 1);
        }
        this.init = true;
    }

    private void init_TagertRowIndex(int index) {
        this.init_DataTable(index);
        try {
            this.init_filter(index);
        }
        catch (Throwable e) {
            LogSvr.getInstance().error(e.getMessage(), e);
            throw new RuntimeException("EntityArrayList\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\uff01");
        }
    }

    private void init_filter(int rowIndex) throws Throwable {
        int length;
        if (this.init) {
            return;
        }
        if (this.filterList == null) {
            return;
        }
        if (this.filterList instanceof EntityArrayList) {
            EntityArrayList tmp = (EntityArrayList)this.filterList;
            tmp.initAll();
        }
        if ((length = this.rowIndexes.length) < rowIndex) {
            throw new RuntimeException("EntityArrayList\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\uff01");
        }
        int start = 0;
        if (this.inner != null) {
            start = this.inner.size();
        } else {
            this.inner = EntityUtil.newSmallArrayList(length);
        }
        boolean canFastFilter = true;
        int i = start;
        while (i < length && i < rowIndex + 1) {
            int tmpIndex = this.rowIndexes[i];
            if (tmpIndex > this.filterList.size()) {
                throw new RuntimeException("EntityArrayList\u672a\u77e5\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\uff01");
            }
            AbstractTableEntity tmp = (AbstractTableEntity)this.filterList.get(tmpIndex);
            if (this.dataTable != tmp.getDataTable() || this.dataTable.getBookmark(tmpIndex) != tmp.getBookMark()) {
                canFastFilter = false;
                break;
            }
            this.inner.add(tmp);
            ++i;
        }
        if (canFastFilter) {
            return;
        }
        Boolean match = false;
        this.inner = EntityUtil.newSmallArrayList(length);
        for (AbstractTableEntity entity : this.filterList) {
            match = true;
            for (Map.Entry<String, Object> entry : this.filterFieldValues.entrySet()) {
                Object curValue;
                String column = entry.getKey();
                Object value = entry.getValue();
                if (EntityUtil.isEquals(value, curValue = entity.valueByColumnName(column))) continue;
                match = false;
            }
            if (!match.booleanValue()) continue;
            this.inner.add(entity);
        }
        this.init = true;
    }

    private void init_DataTable(int index) {
        if (this.init) {
            return;
        }
        if (this.filterList != null) {
            return;
        }
        try {
            if (this.curRst != null) {
                int start = 0;
                int length = this.curRst.size();
                if (this.inner != null) {
                    start = this.inner.size();
                } else {
                    this.inner = EntityUtil.newSmallArrayList(length);
                }
                int rowIndex = start;
                while (rowIndex < index + 1 && rowIndex < length) {
                    Long oid = this.curRst.getLong(rowIndex, "OID");
                    Constructor<E> constructor = this.clz.getDeclaredConstructor(RichDocumentContext.class, AbstractBillEntity.class, DataTable.class, Long.class, Integer.TYPE, String.class);
                    constructor.setAccessible(true);
                    AbstractTableEntity tableEntity = (AbstractTableEntity)constructor.newInstance(this.context, this.parent, this.curRst, oid, rowIndex, this.tableKey);
                    tableEntity.billEntity = this.parent;
                    this.map.put(oid, tableEntity);
                    this.inner.add(tableEntity);
                    ++rowIndex;
                }
            } else {
                this.inner = EntityUtil.newSmallArrayList();
            }
        }
        catch (Exception e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u5b9e\u4f53\u7c7b\u521d\u59cb\u5316\u51fa\u9519\uff01");
        }
    }

    @Override
    public int size() {
        if (this.init) {
            return this.inner.size();
        }
        if (this.rowIndexes != null) {
            return this.rowIndexes.length;
        }
        if (this.curRst == null) {
            return 0;
        }
        return this.curRst.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        this.initAll();
        return this.inner.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        this.initAll();
        return this.inner.iterator();
    }

    @Override
    public Object[] toArray() {
        this.initAll();
        return this.inner.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.initAll();
        return this.inner.toArray(a);
    }

    @Override
    public boolean add(E e) {
        if (!this.init) {
            this.initAll();
        } else {
            this.inner.add(e);
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.initAll();
        return this.inner.remove(o);
    }

    @Override
    public void clear() {
        if (this.inner != null) {
            this.inner.clear();
        }
    }

    @Override
    public E get(int index) {
        this.init_TagertRowIndex(index);
        return (E)((AbstractTableEntity)this.inner.get(index));
    }

    @Override
    public E remove(int index) {
        this.initAll();
        AbstractTableEntity e = (AbstractTableEntity)this.inner.remove(index);
        return (E)e;
    }

    @Override
    public int indexOf(Object o) {
        this.initAll();
        return this.inner.indexOf(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.initAll();
        return this.inner.containsAll(c);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.initAll();
        return this.inner.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.initAll();
        return this.inner.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.initAll();
        return this.inner.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.initAll();
        return this.inner.retainAll(c);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.initAll();
        return this.inner.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.initAll();
        return this.inner.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.initAll();
        return this.inner.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.initAll();
        return this.inner.subList(fromIndex, toIndex);
    }

    public boolean isInit() {
        return this.init;
    }

    public String toString() {
        if (this.init) {
            return this.inner.toString();
        }
        String ret = "init=" + this.init + "\n";
        ret = String.valueOf(ret) + "size=" + this.size() + "\n";
        if (this.inner != null) {
            ret = String.valueOf(ret) + "innerSize=" + this.inner.size() + "\n";
            ret = String.valueOf(ret) + "inner=\n" + this.inner + "\n";
        }
        return ret;
    }
}

