/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.AbstractWhereExpressionParser;
import com.bokesoft.erp.entity.util.WhereExpression;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AndExpression
extends WhereExpression {
    private List<WhereExpression> sub = null;
    private boolean sort = false;
    private static final Map<String, Integer> SystemFieldWherePriority = new HashMap<String, Integer>(4);

    public AndExpression(WhereExpression l, WhereExpression r) {
        SystemFieldWherePriority.put("CLIENTID", 1);
        SystemFieldWherePriority.put("OID", 2);
        SystemFieldWherePriority.put("SOID", 3);
        SystemFieldWherePriority.put("POID", 4);
        this.sub = new ArrayList<WhereExpression>();
        this.sub.add(l);
        this.sub.add(r);
    }

    public void addExpression(WhereExpression expression) {
        this.sub.add(expression);
    }

    @Override
    public SqlString toSQL(boolean tableNamePrefix) throws Throwable {
        this.pSortAndExpression();
        SqlString stringBuilder = new SqlString(128);
        for (WhereExpression w : this.sub) {
            stringBuilder.append(new Object[]{" and "}).append(new Object[]{w.toSQL(tableNamePrefix)});
        }
        stringBuilder.deleteLeft(4);
        return stringBuilder;
    }

    @Override
    public SqlString toSQL(SqlString sqlString, boolean tableNamePrefix) throws Throwable {
        this.pSortAndExpression();
        int i = 0;
        int size = this.sub.size();
        while (i < size) {
            WhereExpression w = this.sub.get(i);
            if (i != 0) {
                sqlString.append(new Object[]{" and "});
            }
            w.toSQL(sqlString, tableNamePrefix);
            ++i;
        }
        return sqlString;
    }

    @Override
    public List<MetaTable> getMetaTables() {
        ArrayList<MetaTable> result = new ArrayList<MetaTable>();
        for (WhereExpression w : this.sub) {
            List<MetaTable> rightTables = w.getMetaTables();
            int i = 0;
            while (i < rightTables.size()) {
                if (!result.contains(rightTables.get(i))) {
                    result.add(rightTables.get(i));
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    boolean isMatch(AbstractTableEntity tableEntity) throws Throwable {
        for (WhereExpression w : this.sub) {
            if (w.isMatch(tableEntity)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isSame(WhereExpression whereExpression) throws Throwable {
        if (whereExpression instanceof AndExpression) {
            AndExpression tmp = (AndExpression)whereExpression;
            if (this.sub.size() != tmp.sub.size()) {
                return false;
            }
            this.pSortAndExpression();
            tmp.pSortAndExpression();
            int index = 0;
            while (index < this.sub.size()) {
                if (!this.containsExpression(tmp.sub, this.sub.get(index))) {
                    return false;
                }
                ++index;
            }
            return true;
        }
        return false;
    }

    private boolean containsExpression(List<WhereExpression> sub, WhereExpression whereExpression) throws Throwable {
        for (WhereExpression tmp : sub) {
            if (!tmp.isSame(whereExpression)) continue;
            return true;
        }
        return false;
    }

    private void pSortAndExpression() {
        if (this.sort) {
            return;
        }
        this.pSortAndExpression(this.sub);
        this.sort = true;
    }

    private void pSortAndExpression(List<WhereExpression> whereExpression) {
        Collections.sort(whereExpression, new Comparator<WhereExpression>(){

            @Override
            public int compare(WhereExpression arg1, WhereExpression arg2) {
                try {
                    String key1 = arg1.getMetaColumn().getKey();
                    String key2 = arg2.getMetaColumn().getKey();
                    if (SystemFieldWherePriority.containsKey(key1) && SystemFieldWherePriority.containsKey(key2)) {
                        return ((Integer)SystemFieldWherePriority.get(key1)).compareTo((Integer)SystemFieldWherePriority.get(key2));
                    }
                    if (SystemFieldWherePriority.containsKey(key1) && !SystemFieldWherePriority.containsKey(key2)) {
                        return -1;
                    }
                    if (!SystemFieldWherePriority.containsKey(key1)) {
                        if (SystemFieldWherePriority.containsKey(key2)) {
                            return 1;
                        }
                    }
                }
                finally {
                    return 0;
                }
            }
        });
    }

    @Override
    public boolean hasMetaColumnWhereClause(MetaColumn metaColumn) {
        for (WhereExpression w : this.sub) {
            if (!w.hasMetaColumnWhereClause(metaColumn)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String parse(AbstractWhereExpressionParser parser) throws Throwable {
        StringBuffer parse = new StringBuffer();
        for (WhereExpression w : this.sub) {
            parse.append(" \u5e76\u4e14 ").append(w.parse(parser));
        }
        String str = parse.toString();
        str = StringUtil.mid((String)str, (int)4);
        return str;
    }

    @Override
    public HashMap<String, MetaColumn> getMetaColumns() throws Throwable {
        HashMap<String, MetaColumn> fields = new HashMap<String, MetaColumn>();
        for (WhereExpression w : this.sub) {
            for (MetaColumn metaColumn : w.getMetaColumns().values()) {
                if (fields.containsKey(metaColumn.getKey())) continue;
                fields.put(metaColumn.getKey(), metaColumn);
            }
        }
        return fields;
    }

    @Override
    public Object getMetaColumnValue(MetaColumn metaColumn) {
        for (WhereExpression w : this.sub) {
            if (!w.hasMetaColumnWhereClause(metaColumn)) continue;
            return w.getMetaColumnValue(metaColumn);
        }
        return null;
    }

    @Override
    public MetaColumn getMetaColumn() throws Throwable {
        throw new Exception("\u4e0d\u5e94\u8be5\u8dd1\u5230\u8fd9\u91cc");
    }

    public List<WhereExpression> getSubList() {
        return this.sub;
    }
}

