/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractLoader;
import com.bokesoft.erp.entity.util.AbstractTableEntity;
import com.bokesoft.erp.entity.util.EntityHelper;
import com.bokesoft.erp.entity.util.TableColumnKey;
import com.bokesoft.erp.entity.util.TableEntityManager;
import com.bokesoft.erp.entity.util.WhereExpression;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDict;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import java.math.BigDecimal;
import java.util.Objects;

public abstract class AbstractTableLoader<T>
extends AbstractLoader<T> {
    public AbstractTableLoader(RichDocumentContext context, String tableKey) throws Throwable {
        super(context, null, null, tableKey);
        this._metaFormKeys = AbstractLoader.getMetaFormKeys(tableKey);
        this._dataObjectKeys = AbstractLoader.getDataObjectKeys(tableKey);
    }

    private MetaColumn getMetaColumn(String metaColumnKey) throws Throwable {
        MetaColumn metaColumn;
        MetaTable metaTable;
        TableColumnKey key = new TableColumnKey(this._tableKey, metaColumnKey);
        MetaColumn result = (MetaColumn)metaColumns.get(key);
        if (result != null) {
            return result;
        }
        IMetaFactory metaFactory = this.context.getMetaFactory(false);
        int index = 0;
        while (index < this._metaFormKeys.length) {
            String formKey = this._metaFormKeys[index];
            MetaForm metaForm = metaFactory.getMetaForm(formKey);
            metaTable = metaForm.getMetaTable(this._tableKey);
            metaColumn = (MetaColumn)metaTable.get(metaColumnKey);
            if (metaColumn != null) {
                metaColumn.setTable(metaTable);
                MetaComponent metaComponent = metaForm.getComponentByDataBinding(metaTable.getKey(), metaColumnKey);
                if (metaComponent != null) {
                    if (metaComponent.getControlType() == 206) {
                        MetaDict dict = (MetaDict)metaComponent;
                        metaColumn.setItemKey(dict.getItemKey());
                    }
                } else {
                    MetaGridCell metaGridCell = metaForm.getCellByDataBinding(metaTable.getKey(), metaColumnKey);
                    if (metaGridCell != null && (metaGridCell.getCellType() == 206 || metaGridCell.getCellType() == 241 || metaGridCell.getCellType() == 242)) {
                        MetaDictProperties dicProperties = (MetaDictProperties)metaGridCell.getProperties();
                        String itemKey = dicProperties.getItemKey();
                        metaColumn.setItemKey(itemKey);
                    }
                }
                metaColumns.put(key, metaColumn);
                return metaColumn;
            }
            ++index;
        }
        index = 0;
        while (index < this._dataObjectKeys.length) {
            String dataObjectKey = this._dataObjectKeys[index];
            MetaDataObject dataObject = metaFactory.getDataObject(dataObjectKey);
            metaTable = dataObject.getTable(this._tableKey);
            metaColumn = (MetaColumn)metaTable.get(metaColumnKey);
            if (metaColumn != null) {
                metaColumn.setTable(metaTable);
                metaColumns.put(key, metaColumn);
                return metaColumn;
            }
            ++index;
        }
        return null;
    }

    @Override
    protected MetaColumn getClusterMetaColumn() throws Throwable {
        return this.getMetaColumn(this.clusterKey());
    }

    protected void addMetaColumnValueObject(String metaColumnKey, Object value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumn(metaColumnKey);
        if (metaColumn == null) {
            throw new Exception("\u4e0d\u5b58\u5728\u6570\u636e\u5e93\u5b57\u6bb5 " + metaColumnKey);
        }
        this.whereExpression = this.whereExpression == null ? WhereExpression.eq(metaColumn, value) : this.whereExpression.addEQ(metaColumn, value);
    }

    protected void addMetaColumnValueObject(String metaColumnKey, Object value, String itemKey) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumn(metaColumnKey);
        if (metaColumn == null) {
            throw new Exception("\u4e0d\u5b58\u5728\u6570\u636e\u5e93\u5b57\u6bb5 " + metaColumnKey);
        }
        metaColumn.setItemKey(itemKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.eq(metaColumn, value) : this.whereExpression.addEQ(metaColumn, value);
    }

    private void addMetaColumnValueObjectIn(String MetaColumnKey, String[] value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumn(MetaColumnKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.in(metaColumn, value) : this.whereExpression.addIN(metaColumn, value);
        this.hasIn = true;
    }

    private void addMetaColumnValueObjectIn(String MetaColumnKey, int[] value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumn(MetaColumnKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.in(metaColumn, value) : this.whereExpression.addIN(metaColumn, value);
        this.hasIn = true;
    }

    private void addMetaColumnValueObjectLong(String MetaColumnKey, Long[] value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumn(MetaColumnKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.in(metaColumn, value) : this.whereExpression.addLong(metaColumn, value);
        this.hasIn = true;
    }

    private void addMetaColumnValueObjectIn(String MetaColumnKey, Integer[] value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumn(MetaColumnKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.in(metaColumn, value) : this.whereExpression.addIN(metaColumn, value);
        this.hasIn = true;
    }

    public AbstractTableLoader<T> addMetaColumnValueObjectOperator(String MetaColumnKey, String operator, Object value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumn(MetaColumnKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.operator(metaColumn, operator, value) : this.whereExpression.addOperator(metaColumn, operator, value);
        return this;
    }

    public void addMetaColumnValue(String metaColumnKey, int value) throws Throwable {
        this.addMetaColumnValueObject(metaColumnKey, value);
    }

    public void addMetaColumnValue(String metaColumnKey, Long value) throws Throwable {
        this.addMetaColumnValueObject(metaColumnKey, value);
    }

    public void addMetaColumnValue(String metaColumnKey, Long value, String itemKey) throws Throwable {
        this.addMetaColumnValueObject(metaColumnKey, value, itemKey);
    }

    public void addMetaColumnValue(String metaColumnKey, String value) throws Throwable {
        this.addMetaColumnValueObject(metaColumnKey, value);
    }

    public void addMetaColumnValue(String metaColumnKey, int[] value) throws Throwable {
        this.addMetaColumnValueObjectIn(metaColumnKey, value);
    }

    public void addMetaColumnValue(String metaColumnKey, Long[] value) throws Throwable {
        this.addMetaColumnValueObjectLong(metaColumnKey, value);
    }

    public void addMetaColumnValue(String metaColumnKey, Integer[] value) throws Throwable {
        this.addMetaColumnValueObjectIn(metaColumnKey, value);
    }

    public void addMetaColumnValue(String metaColumnKey, String[] value) throws Throwable {
        this.addMetaColumnValueObjectIn(metaColumnKey, value);
    }

    public void addMetaColumnValue(String metaColumnKey, BigDecimal value) throws Throwable {
        this.addMetaColumnValueObject(metaColumnKey, value);
    }

    public void preLoading() throws Throwable {
        TableEntityManager.preLoadingTableEntityData(this.context, this);
    }

    @Override
    public boolean existCluster() {
        return false;
    }

    @Override
    public String clusterKey() {
        return "";
    }

    protected void throwTableEntityNotNullError(Class<? extends AbstractTableEntity> entityClass, int id) throws Throwable {
        String tableName = EntityHelper.getInstance().getEntityClassNameMap().getTableName(entityClass);
        String tableCaption = AbstractTableLoader.getTableCaption(entityClass);
        String errorCaption = ERPStringUtil.isBlankOrNull((Object)tableCaption) || Objects.equals(tableName, tableCaption) ? tableName : String.valueOf(tableCaption) + "(" + tableName + ")";
        throw new Exception(String.valueOf(errorCaption) + " \u53d6\u4e0d\u5230\u4e3b\u952e\u503c\u4e3a " + id + "\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u76f8\u5173\u8bbe\u7f6e!");
    }

    protected void throwTableEntityNotNullError(Class<? extends AbstractTableEntity> entityClass) throws Throwable {
        String tableName = EntityHelper.getInstance().getEntityClassNameMap().getTableName(entityClass);
        String tableCaption = AbstractTableLoader.getTableCaption(entityClass);
        String errorCaption = ERPStringUtil.isBlankOrNull((Object)tableCaption) || Objects.equals(tableName, tableCaption) ? tableName : String.valueOf(tableCaption) + "(" + tableName + ")";
        throw new Exception(String.valueOf(errorCaption) + " \u53d6\u4e0d\u5230\u6761\u4ef6\u4e3a " + this.parseWhereExpression() + "\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u76f8\u5173\u8bbe\u7f6e!");
    }

    public static void throwTableEntityNotNullError(Class<? extends AbstractTableEntity> entityClass, Long oid) throws Throwable {
        String tableName = EntityHelper.getInstance().getEntityClassNameMap().getTableName(entityClass);
        String tableCaption = AbstractTableLoader.getTableCaption(entityClass);
        String errorCaption = ERPStringUtil.isBlankOrNull((Object)tableCaption) || Objects.equals(tableName, tableCaption) ? tableName : String.valueOf(tableCaption) + "(" + tableName + ")";
        throw new Exception(String.valueOf(errorCaption) + " \u53d6\u4e0d\u5230\u4e3b\u952e\u503c\u4e3a" + oid + "\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u76f8\u5173\u8bbe\u7f6e!");
    }

    protected void throwTableEntityListNotNullError(Class<? extends AbstractTableEntity> entityClass) throws Throwable {
        String tableName = EntityHelper.getInstance().getEntityClassNameMap().getTableName(entityClass);
        String tableCaption = AbstractTableLoader.getTableCaption(entityClass);
        String errorCaption = ERPStringUtil.isBlankOrNull((Object)tableCaption) || Objects.equals(tableName, tableCaption) ? tableName : String.valueOf(tableCaption) + "(" + tableName + ")";
        throw new Exception(String.valueOf(errorCaption) + " \u53d6\u4e0d\u5230\u6761\u4ef6\u4e3a " + this.parseWhereExpression() + "\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u76f8\u5173\u8bbe\u7f6e!");
    }
}

