/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.util;

import com.bokesoft.erp.entity.util.AbstractBillEntity;
import com.bokesoft.erp.entity.util.AbstractLoader;
import com.bokesoft.erp.entity.util.EntityHelper;
import com.bokesoft.erp.entity.util.TableColumnKeyByForm;
import com.bokesoft.erp.entity.util.WhereExpression;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPStringUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractBillLoader<T>
extends AbstractLoader<T> {
    private static final Map<TableColumnKeyByForm, MetaColumn> metaColumns = new LinkedHashMap<TableColumnKeyByForm, MetaColumn>();

    public AbstractBillLoader(RichDocumentContext context, String metaFormKey) {
        super(context, metaFormKey);
    }

    public void addFieldValue(String metaColumnKey, int value) throws Throwable {
        this.addFieldValueObject(metaColumnKey, value);
    }

    public void addFieldValue(String metaColumnKey, Long value) throws Throwable {
        this.addFieldValueObject(metaColumnKey, value);
    }

    public void addFieldValue(String metaColumnKey, String value) throws Throwable {
        this.addFieldValueObject(metaColumnKey, value);
    }

    public void addFieldValue(String metaColumnKey, int[] value) throws Throwable {
        this.addFieldValueObjectIn(metaColumnKey, value);
    }

    public void addFieldValue(String metaColumnKey, Long[] value) throws Throwable {
        this.addFieldValueObjectLong(metaColumnKey, value);
    }

    public void addFieldValue(String metaColumnKey, Integer[] value) throws Throwable {
        this.addFieldValueObjectIn(metaColumnKey, value);
    }

    public void addFieldValue(String metaColumnKey, String[] value) throws Throwable {
        this.addFieldValueObjectIn(metaColumnKey, value);
    }

    public void addFieldValue(String metaColumnKey, BigDecimal value) throws Throwable {
        this.addFieldValueObject(metaColumnKey, value);
    }

    protected void addFieldValueObject(String fieldKey, Object value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumnByFieldKey(fieldKey);
        if (metaColumn == null) {
            throw new Exception("\u4e0d\u5b58\u5728\u5b57\u6bb5 " + fieldKey);
        }
        this.whereExpression = this.whereExpression == null ? WhereExpression.eq(metaColumn, value) : this.whereExpression.addEQ(metaColumn, value);
    }

    private void addFieldValueObjectIn(String fieldKey, String[] value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumnByFieldKey(fieldKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.in(metaColumn, value) : this.whereExpression.addIN(metaColumn, value);
        this.hasIn = true;
    }

    private void addFieldValueObjectIn(String fieldKey, int[] value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumnByFieldKey(fieldKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.in(metaColumn, value) : this.whereExpression.addIN(metaColumn, value);
        this.hasIn = true;
    }

    private void addFieldValueObjectLong(String fieldKey, Long[] value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumnByFieldKey(fieldKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.in(metaColumn, value) : this.whereExpression.addLong(metaColumn, value);
        this.hasIn = true;
    }

    private void addFieldValueObjectIn(String fieldKey, Integer[] value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumnByFieldKey(fieldKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.in(metaColumn, value) : this.whereExpression.addIN(metaColumn, value);
        this.hasIn = true;
    }

    public AbstractBillLoader<T> addFieldValueObjectOperator(String fieldKey, String operator, Object value) throws Throwable {
        MetaColumn metaColumn = this.getMetaColumnByFieldKey(fieldKey);
        this.whereExpression = this.whereExpression == null ? WhereExpression.operator(metaColumn, operator, value) : this.whereExpression.addOperator(metaColumn, operator, value);
        return this;
    }

    @Override
    protected MetaColumn getClusterMetaColumn() throws Throwable {
        return this.getMetaColumnByFieldKey(this.clusterKey());
    }

    private MetaColumn getMetaColumnByFieldKey(String fieldKey) throws Throwable {
        TableColumnKeyByForm key = new TableColumnKeyByForm(this._metaFormKeys, fieldKey);
        if (metaColumns.containsKey(key)) {
            return metaColumns.get(key);
        }
        IMetaFactory metaFactory = this.context.getMetaFactory();
        int index = 0;
        while (index < this._metaFormKeys.length) {
            String formKey = this._metaFormKeys[index];
            MetaForm metaForm = metaFactory.getMetaForm(formKey);
            MetaComponent component = metaForm.componentByKey(fieldKey);
            if (fieldKey.equalsIgnoreCase("OID")) {
                MetaTable metaTable = metaForm.getDataSource().getDataObject().getMainTable();
                MetaColumn metaColumn = (MetaColumn)metaTable.get(fieldKey);
                metaColumn.setTable(metaTable);
                return metaColumn;
            }
            if (component != null) {
                String columnKey = component.getMetaDataBinding().getColumnKey();
                String tableKey = component.getMetaDataBinding().getTableKey();
                MetaTable metaTable = metaForm.getMetaTable(tableKey);
                MetaColumn metaColumn = (MetaColumn)metaTable.get(columnKey);
                metaColumn.setTable(metaTable);
                metaColumns.put(key, metaColumn);
                return metaColumn;
            }
            MetaGridCell metaGridCell = metaForm.metaGridCellByKey(fieldKey);
            if (metaGridCell != null) {
                MetaDataBinding dataBinding = metaGridCell.getDataBinding();
                String columnKey = metaGridCell.getColumnKey();
                String tableKey = dataBinding.getTableKey();
                if (StringUtil.isBlankOrNull((String)tableKey)) {
                    tableKey = metaGridCell.getTableKey();
                }
                MetaTable metaTable = metaForm.getMetaTable(tableKey);
                MetaColumn metaColumn = (MetaColumn)metaTable.get(columnKey);
                metaColumn.setTable(metaTable);
                metaColumns.put(key, metaColumn);
                return metaColumn;
            }
            ++index;
        }
        return null;
    }

    @Override
    public boolean existCluster() {
        return true;
    }

    @Override
    public String clusterKey() {
        return "ClientID";
    }

    protected void throwBillEntityNotNullError(Class<? extends AbstractBillEntity> entityClass, Long id) throws Throwable {
        String billKey = EntityHelper.getInstance().getEntityClassNameMap().getBillKey(entityClass);
        String formCaption = this.getMetaFormCaption(billKey);
        String errorCaption = ERPStringUtil.isBlankOrNull((Object)formCaption) || Objects.equals(billKey, formCaption) ? billKey : String.valueOf(formCaption) + "(" + billKey + ")";
        throw new Exception("\u8868\u5355 " + errorCaption + " \u53d6\u4e0d\u5230\u4e3b\u952e\u503c\u4e3a " + id + "\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u76f8\u5173\u8bbe\u7f6e!");
    }

    protected void throwBillEntityNotNullError(Class<? extends AbstractBillEntity> entityClass) throws Throwable {
        String billKey = EntityHelper.getInstance().getEntityClassNameMap().getBillKey(entityClass);
        String formCaption = this.getMetaFormCaption(billKey);
        String errorCaption = ERPStringUtil.isBlankOrNull((Object)formCaption) || Objects.equals(billKey, formCaption) ? billKey : String.valueOf(formCaption) + "(" + billKey + ")";
        throw new Exception("\u8868\u5355 " + errorCaption + " \u53d6\u4e0d\u5230\u6761\u4ef6\u4e3a " + this.parseWhereExpression() + "\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u76f8\u5173\u8bbe\u7f6e!");
    }

    protected void throwBillEntityListNotNullError(Class<? extends AbstractBillEntity> entityClass) throws Throwable {
        String billKey = EntityHelper.getInstance().getEntityClassNameMap().getBillKey(entityClass);
        String formCaption = this.getMetaFormCaption(billKey);
        String errorCaption = ERPStringUtil.isBlankOrNull((Object)formCaption) || Objects.equals(billKey, formCaption) ? billKey : String.valueOf(formCaption) + "(" + billKey + ")";
        throw new Exception("\u8868\u5355 " + errorCaption + " \u53d6\u4e0d\u5230\u6761\u4ef6\u4e3a " + this.parseWhereExpression() + "\u7684\u6570\u636e,\u8bf7\u68c0\u67e5\u76f8\u5173\u8bbe\u7f6e!");
    }

    @Override
    public Object loadList() throws Throwable {
        throw new Exception("\u4e0d\u80fd\u4f7f\u7528");
    }

    @Override
    public Object loadListNotNull() throws Throwable {
        throw new Exception("\u4e0d\u80fd\u4f7f\u7528");
    }
}

