/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.entity.genentity;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import java.util.ArrayList;
import java.util.List;

public class MetaFormTables {
    private static MetaFormTables instance;
    HashMapIgnoreCase<List<String>> table2FormKeys = new HashMapIgnoreCase();

    private MetaFormTables() {
    }

    public static MetaFormTables getInstance(IMetaFactory metaFactory) throws Throwable {
        if (instance == null) {
            MetaFormTables metaFormTables = new MetaFormTables();
            metaFormTables.init(metaFactory);
            instance = metaFormTables;
        }
        return instance;
    }

    private void init(IMetaFactory metaFactory) throws Throwable {
        for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
            MetaDataObject metaDataObject;
            MetaTableCollection metaTables;
            MetaForm metaForm = metaFactory.getMetaForm(metaFormProfile.getKey());
            MetaDataSource metaDataSource = metaForm.getDataSource();
            if (metaDataSource == null || (metaTables = (metaDataObject = metaDataSource.getDataObject()).getTableCollection()) == null) continue;
            for (MetaTable metaTable : metaTables) {
                String tableName = metaTable.getBindingDBTableName();
                List<String> formKeys = (ArrayList<String>)this.table2FormKeys.get(tableName);
                if (formKeys == null) {
                    formKeys = new ArrayList<String>();
                    this.table2FormKeys.put(tableName, formKeys);
                }
                formKeys.add(metaForm.getKey());
                String tableKey = metaTable.getKey();
                if (tableKey.equalsIgnoreCase(tableName)) continue;
                formKeys = (List)this.table2FormKeys.get(tableKey);
                if (formKeys == null) {
                    formKeys = new ArrayList();
                    this.table2FormKeys.put(tableKey, formKeys);
                }
                formKeys.add(metaForm.getKey());
            }
        }
    }

    public List<String> getMetaFormKeys(String tableKey) {
        return (List)this.table2FormKeys.get(tableKey);
    }
}

