/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.util.Directory;
import com.bokesoft.yes.util.Element;
import com.bokesoft.yes.util.FilePathIngoreCase;
import java.io.File;
import java.util.ArrayList;

class FilePath {
    Element[] elements;
    String[] paths;
    String orgFilePath;

    public FilePath(String filePath) {
        this.orgFilePath = filePath;
        this.paths = StringUtil.split((String)filePath, (String)"/\\");
        ArrayList<String> tmp = new ArrayList<String>();
        String[] stringArray = this.paths;
        int n = this.paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path != null && path.length() > 0) {
                tmp.add(path);
            }
            ++n2;
        }
        this.paths = tmp.toArray(new String[0]);
        int count = this.paths.length;
        this.elements = new Element[count];
        Directory parent = FilePathIngoreCase.root;
        int i = 0;
        while (i < count) {
            Element elm = parent.getElement(this.paths[i]);
            if (elm == null) {
                return;
            }
            this.elements[i] = elm;
            if (i == count - 1 || elm.isFile()) {
                return;
            }
            parent = (Directory)elm;
            ++i;
        }
    }

    public String getRealPath() {
        String result;
        int count = this.elements.length;
        if (this.isExist()) {
            return this.elements[count - 1].path;
        }
        int lastExistIndex = count - 1;
        while (lastExistIndex >= 0) {
            if (this.elements[lastExistIndex] != null) break;
            --lastExistIndex;
        }
        String string = result = lastExistIndex >= 0 ? this.elements[lastExistIndex].path : "";
        if (!result.endsWith(File.separator)) {
            result = String.valueOf(result) + File.separator;
        }
        int i = lastExistIndex + 1;
        while (i < count) {
            result = String.valueOf(result) + this.paths[i];
            if (i != count - 1) {
                result = String.valueOf(result) + File.separator;
            }
            ++i;
        }
        if (this.orgFilePath.endsWith(File.separator)) {
            result = String.valueOf(result) + File.separator;
        }
        return result;
    }

    private boolean isExist() {
        int count = this.elements.length;
        return count != 0 && this.elements[count - 1] != null;
    }
}

