/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ERPDateUtil {
    private static final Logger logger = LoggerFactory.getLogger(ERPDateUtil.class);
    public static final String DATE_INTERVAL_SECOND = "s";
    public static final String DATE_INTERVAL_MINUTE = "n";
    public static final String DATE_INTERVAL_HOUR = "h";
    public static final String DATE_INTERVAL_DAY = "d";
    public static final String DATE_INTERVAL_WEEK = "ww";
    public static final String DATE_INTERVAL_MONTH = "m";
    public static final String DATE_INTERVAL_QUARTER = "q";
    public static final String DATE_INTERVAL_YEAR = "yyyy";
    @Deprecated
    public static final String DATE_INTERVAL_DATEOFYEAR = "dd";
    @Deprecated
    public static final String DATE_INTERVAL_DAYOFYEAR = "y";
    @Deprecated
    public static final String DATE_INTERVAL_DAYOFWEEK = "w";
    @Deprecated
    public static final String DATE_INTERVAL_MONTHOFYEAR = "mm";
    public static final String DATE_FORMAT_DATELONG = "yyyyMMdd";
    private static final ZoneId SYSTEM_ZONE = ZoneId.systemDefault();
    private static final Clock SYSTEM_CLOCK = Clock.systemDefaultZone();
    private static Clock clock;
    private static long baseTimeMillis;

    static {
        baseTimeMillis = 0L;
        clock = SYSTEM_CLOCK;
    }

    private ERPDateUtil() {
    }

    private static Clock getClock() {
        if (baseTimeMillis != 0L && !SYSTEM_CLOCK.equals(clock)) {
            return Clock.offset(clock, Duration.ofMillis(System.currentTimeMillis() - baseTimeMillis));
        }
        return clock;
    }

    public static void setFixedTime(String fixedTime) {
        clock = ERPDateUtil.parseFixedTime(fixedTime);
    }

    public static void setOffsetTime(String fixedTime) {
        clock = ERPDateUtil.parseFixedTime(fixedTime);
        baseTimeMillis = System.currentTimeMillis();
    }

    private static Clock parseFixedTime(String fixedTime) {
        if (StringUtils.isBlank((CharSequence)fixedTime)) {
            return SYSTEM_CLOCK;
        }
        ZoneId systemDefault = ZoneId.systemDefault();
        LocalDateTime dateTime = LocalDateTime.parse(fixedTime, DateTimeFormatter.ISO_DATE_TIME);
        Instant instant = dateTime.atZone(systemDefault).toInstant();
        Clock fixedClock = Clock.fixed(instant, systemDefault);
        return fixedClock;
    }

    private static LocalDateTime now() {
        LocalDateTime now = LocalDateTime.now(ERPDateUtil.getClock());
        return now;
    }

    private static java.util.Date toDate(LocalDateTime localDateTime) {
        long millis = localDateTime.atZone(SYSTEM_ZONE).toInstant().toEpochMilli();
        return new java.util.Date(millis);
    }

    private static Date toSQLDate(LocalDateTime localDateTime) {
        long millis = localDateTime.toLocalDate().atStartOfDay(SYSTEM_ZONE).toInstant().toEpochMilli();
        return new Date(millis);
    }

    private static Timestamp toTimestamp(LocalDateTime localDateTime) {
        long millis = localDateTime.atZone(SYSTEM_ZONE).toInstant().toEpochMilli();
        return new Timestamp(millis);
    }

    public static Long toDateLong(LocalDateTime localDateTime) {
        int year = localDateTime.getYear();
        int monthValue = localDateTime.getMonthValue();
        int days = localDateTime.getDayOfMonth();
        return (long)(year * 10000 + monthValue * 100 + days) + 0L;
    }

    private static Long toTimeLong(LocalDateTime localDateTime) {
        int year = localDateTime.getYear();
        int monthValue = localDateTime.getMonthValue();
        int days = localDateTime.getDayOfMonth();
        int hours = localDateTime.getHour();
        int minute = localDateTime.getMinute();
        int seconds = localDateTime.getSecond();
        return (long)year * 10000000000L + (long)(monthValue * 100000000) + (long)(days * 1000000) + (long)(hours * 10000) + (long)(minute * 100) + (long)seconds;
    }

    private static LocalDateTime toLocalDateTime(Object date) {
        if (date == null || date.equals(0L)) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u7c7b\u578b\uff1a" + date);
        }
        try {
            if (date instanceof String && StringUtil.isNumeric((Object)date)) {
                date = TypeConvertor.toLong((Object)date);
            }
            if (date instanceof LocalDateTime) {
                return (LocalDateTime)date;
            }
            if (date instanceof LocalDate) {
                LocalDate localDate = (LocalDate)date;
                return localDate.atStartOfDay(SYSTEM_ZONE).toLocalDateTime();
            }
            if (date instanceof Date) {
                Date d = (Date)date;
                LocalDateTime localDateTime = d.toLocalDate().atStartOfDay(SYSTEM_ZONE).toLocalDateTime();
                return localDateTime;
            }
            if (date instanceof java.util.Date) {
                java.util.Date d = (java.util.Date)date;
                LocalDateTime localDateTime = d.toInstant().atZone(SYSTEM_ZONE).toLocalDateTime();
                return localDateTime;
            }
            if (date instanceof Long || date instanceof Integer) {
                Long d = TypeConvertor.toLong((Object)date);
                if (d.compareTo(0L) >= 0 && d.compareTo(235959L) <= 0) {
                    int hour = (int)(d / 10000L);
                    int minute = (int)(d / 100L % 100L);
                    int second = (int)(d % 100L);
                    LocalDateTime localDateTime = LocalDateTime.of(1970, 1, 1, hour, minute, second);
                    return localDateTime;
                }
                if (d.compareTo(19000101L) >= 0 && d.compareTo(99991231L) <= 0) {
                    int year = (int)(d / 10000L);
                    int month = (int)(d / 100L % 100L);
                    int day = (int)(d % 100L);
                    LocalDateTime localDateTime = LocalDateTime.of(year, month, day, 0, 0);
                    return localDateTime;
                }
                if (d.compareTo(19000101000000L) >= 0 && d.compareTo(99991231235959L) <= 0) {
                    long ymd = d / 1000000L;
                    int year = (int)(ymd / 10000L);
                    int month = (int)(ymd / 100L % 100L);
                    int day = (int)(ymd % 100L);
                    long hms = d % 1000000L;
                    int hour = (int)(hms / 10000L);
                    int minute = (int)(hms / 100L % 100L);
                    int second = (int)(hms % 100L);
                    LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, second);
                    return localDateTime;
                }
                Instant instant = Instant.ofEpochMilli(d);
                LocalDateTime localDateTime = instant.atZone(SYSTEM_ZONE).toLocalDateTime();
                return localDateTime;
            }
            if (date instanceof String) {
                String dateString = (String)date;
                if (StringUtils.lastIndexOf((CharSequence)dateString, (CharSequence)"-") == 4) {
                    dateString = String.valueOf(dateString) + "-01";
                } else if (StringUtils.lastIndexOf((CharSequence)dateString, (CharSequence)"/") == 4) {
                    dateString = String.valueOf(dateString) + "/01";
                }
                if (!dateString.contains(" ")) {
                    dateString = dateString.concat(" 00:00:00");
                }
                StringBuilder formatBuilder = new StringBuilder(1024).append("yyyy-MM-dd HH:mm:ss");
                String format = formatBuilder.toString();
                if (dateString.contains("/")) {
                    format = StringUtils.replace((String)format, (String)"-", (String)"/");
                } else if (dateString.contains(".")) {
                    format = StringUtils.replace((String)format, (String)"-", (String)".");
                }
                DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(format);
                LocalDateTime localDateTime = LocalDateTime.parse(dateString, dateTimeFormatter);
                return localDateTime;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u7c7b\u578b\uff1a" + date);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u65f6\u95f4\u7c7b\u578b\uff1a" + date);
    }

    private static boolean isValidDate(int year, int month, int day, int hour, int minute, int second) {
        if (hour < 0 || hour > 23 || minute < 0 || minute > 59 || second < 0 || second > 59) {
            return false;
        }
        if (year < 0 || month < 1 || month > 12 || day < 1 || day > 31) {
            return false;
        }
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return true;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return day <= 30;
            }
            case 2: {
                if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
                    return day <= 29;
                }
                return day <= 28;
            }
        }
        return false;
    }

    private static TemporalUnit getTemporalUnit(String interval) {
        switch (interval) {
            case "s": {
                return ChronoUnit.SECONDS;
            }
            case "n": {
                return ChronoUnit.MINUTES;
            }
            case "h": {
                return ChronoUnit.HOURS;
            }
            case "d": 
            case "w": 
            case "y": 
            case "dd": {
                return ChronoUnit.DAYS;
            }
            case "m": 
            case "mm": {
                return ChronoUnit.MONTHS;
            }
            case "yyyy": {
                return ChronoUnit.YEARS;
            }
            case "ww": {
                return ChronoUnit.WEEKS;
            }
            case "q": {
                return IsoFields.QUARTER_YEARS;
            }
        }
        throw new RuntimeException("\u65e5\u671f\u6dfb\u52a0\u7684\u5355\u4f4d" + interval + "\u672a\u5b9e\u73b0.\u76ee\u524d\u652f\u6301s,\u79d2;n,\u5206;h,\u5c0f\u65f6;d,\u5929;m,\u6708;yyyy,\u5e74;q,\u5b63\u5ea6;ww,\u5468;");
    }

    private static Duration getDuration(Object startDate, Object endDate) {
        LocalDateTime startLocalDate = ERPDateUtil.toLocalDateTime(startDate);
        LocalDateTime endLocalDate = ERPDateUtil.toLocalDateTime(endDate);
        return Duration.between(startLocalDate, endLocalDate);
    }

    public static Long getNowDateLong() {
        Long dateLong = ERPDateUtil.toDateLong(ERPDateUtil.now());
        if (clock != SYSTEM_CLOCK) {
            logger.debug("\u5f53\u524d\u65e5\u671f\uff1a{}", (Object)dateLong);
        }
        return dateLong;
    }

    public static Date getNowDate() {
        Date sqlDate = ERPDateUtil.toSQLDate(ERPDateUtil.now());
        if (clock != SYSTEM_CLOCK) {
            logger.debug("\u5f53\u524d\u65e5\u671f\uff1a{}", (Object)sqlDate);
        }
        return sqlDate;
    }

    public static Timestamp getNowTime() {
        Timestamp timestamp = ERPDateUtil.toTimestamp(ERPDateUtil.now());
        if (clock != SYSTEM_CLOCK) {
            logger.debug("\u5f53\u524d\u65f6\u95f4\uff1a{}", (Object)timestamp);
        }
        return timestamp;
    }

    public static Long toDateLong(java.util.Date date) {
        return ERPDateUtil.toDateLong(ERPDateUtil.toLocalDateTime(date));
    }

    public static Long toDateLong(String date) {
        return ERPDateUtil.toDateLong(ERPDateUtil.toLocalDateTime(date));
    }

    public static Long toDateTimeLong(String date) {
        LocalDateTime localTime = ERPDateUtil.toLocalDateTime(date);
        int year = localTime.getYear();
        int monthValue = localTime.getMonthValue();
        int days = localTime.getDayOfMonth();
        int hour = localTime.getHour();
        int minute = localTime.getMinute();
        int second = localTime.getSecond();
        long dateLong = (long)(year * 10000 + monthValue * 100 + days) + 0L;
        long time = (long)(hour * 10000 + minute * 100 + second) + 0L;
        return dateLong * 1000000L + time;
    }

    public static Long toDateMonthLong(String date) {
        LocalDateTime localTime = ERPDateUtil.toLocalDateTime(date);
        int year = localTime.getYear();
        int monthValue = localTime.getMonthValue();
        long dateLong = year * 100 + monthValue;
        return dateLong;
    }

    public static Long toTimeLong(String date) {
        return ERPDateUtil.toTimeLong(date, null);
    }

    public static Long toTimeLong(String date, String format) {
        String pattern = format;
        if (StringUtils.isBlank((CharSequence)format)) {
            pattern = "HH:mm:ss";
        }
        if (StringUtils.lastIndexOf((CharSequence)date, (CharSequence)":") == 5) {
            pattern = "HH:mm:ss";
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        LocalTime localTime = LocalTime.parse(date, formatter);
        int hour = localTime.getHour();
        int minute = localTime.getMinute();
        int second = localTime.getSecond();
        if ("HH:mm".equals(format) || "HHmm".equals(format)) {
            return (long)hour * 100L + (long)minute;
        }
        return (long)(hour * 10000 + minute * 100 + second) + 0L;
    }

    public static java.util.Date toDate(int year, int month, int dayOfMonth, int hour, int minutes, int seconds) {
        LocalDateTime localDateTime = LocalDateTime.of(year, month, dayOfMonth, hour, minutes, seconds);
        return ERPDateUtil.toDate(localDateTime);
    }

    public static Timestamp toTimestamp(java.util.Date date) throws Throwable {
        return ERPDateUtil.toTimestamp(ERPDateUtil.toLocalDateTime(date));
    }

    public static Timestamp toTimestamp(String date) throws Throwable {
        return ERPDateUtil.toTimestamp(ERPDateUtil.toLocalDateTime(date));
    }

    public static boolean isValidDateLong(Object dateLong) throws Exception {
        if (!StringUtil.isNumeric((Object)dateLong)) {
            throw new Exception("\u65e5\u671f\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        try {
            int date = TypeConvertor.toInteger((Object)dateLong);
            int year = date / 10000;
            int month = date / 100 % 100;
            int day = date % 100;
            return ERPDateUtil.isValidDate(year, month, day, 0, 0, 0);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isValidTime(Object time) throws Exception {
        if (!StringUtil.isNumeric((Object)time)) {
            throw new Exception("\u65f6\u95f4\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        int _time = TypeConvertor.toInteger((Object)time);
        int hour = _time / 10000;
        int minute = _time / 100 % 100;
        int second = _time % 100;
        return ERPDateUtil.isValidDate(0, 1, 1, hour, minute, second);
    }

    public static Long dateLongAdd(String interval, int num, Long dateLong) {
        if (num == 0) {
            return dateLong;
        }
        TemporalUnit temporalUnit = ERPDateUtil.getTemporalUnit(interval);
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(dateLong);
        LocalDateTime plusLocalDateTime = localDateTime.plus(num, temporalUnit);
        Long plusDateLong = ERPDateUtil.toDateLong(plusLocalDateTime);
        return plusDateLong;
    }

    public static Object dateLongDiff(Long startDate, Long endDate, String unit) {
        LocalDateTime startDateTime = ERPDateUtil.toLocalDateTime(startDate);
        LocalDateTime endDateTime = ERPDateUtil.toLocalDateTime(endDate);
        LocalDateTime tempDateTime = LocalDateTime.from(startDateTime);
        Number diff = null;
        if (unit.equalsIgnoreCase("Y")) {
            diff = endDateTime.getYear() - startDateTime.getYear();
        } else if (unit.equalsIgnoreCase("M")) {
            diff = endDateTime.getYear() * 12 + endDateTime.getMonthValue() - (startDateTime.getYear() * 12 + startDateTime.getMonthValue());
        } else if (unit.equalsIgnoreCase("D")) {
            diff = tempDateTime.until(endDateTime, ChronoUnit.DAYS);
        }
        return diff;
    }

    public static Long timeLongAdd(String interval, int num, Long dateLong) {
        if (num == 0) {
            return dateLong;
        }
        TemporalUnit temporalUnit = ERPDateUtil.getTemporalUnit(interval);
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(dateLong);
        LocalDateTime plusLocalDateTime = localDateTime.plus(num, temporalUnit);
        Long plusDateLong = ERPDateUtil.toTimeLong(plusLocalDateTime);
        return plusDateLong;
    }

    public static java.util.Date dateAdd(String interval, int num, java.util.Date date) {
        TemporalUnit temporalUnit = ERPDateUtil.getTemporalUnit(interval);
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        LocalDateTime plusLocalDateTime = localDateTime.plus(num, temporalUnit);
        java.util.Date plusDate = ERPDateUtil.toDate(plusLocalDateTime);
        return plusDate;
    }

    public static String format(Object date, String formatPattern) {
        String pattern = ERPDateUtil.transformFormat(formatPattern);
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(pattern);
        String dateString = dateTimeFormatter.format(ERPDateUtil.toLocalDateTime(date));
        return dateString;
    }

    private static String transformFormat(String formatPattern) {
        if ("YY-MM-DD".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yy-MM-dd";
        } else if ("YYMMDD".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyMMdd";
        } else if ("MM-DD".equalsIgnoreCase(formatPattern)) {
            formatPattern = "MM-dd";
        } else if ("MMDD".equalsIgnoreCase(formatPattern)) {
            formatPattern = "MMdd";
        } else if ("YYYY-MM".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyy-MM";
        } else if ("YYYYMM".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyyMM";
        } else if ("YYYY-MM-DD".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyy-MM-dd";
        } else if ("YYYY-MM-DD HH".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyy-MM-dd HH";
        } else if ("YYYY-MM-DD HH:MM".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyy-MM-dd HH:mm";
        } else if ("YYYY-MM-DD HH:MM:SS".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyy-MM-dd HH:mm:ss";
        } else if ("YYYY".equalsIgnoreCase(formatPattern)) {
            formatPattern = DATE_INTERVAL_YEAR;
        } else if ("YYYYMMDD".equalsIgnoreCase(formatPattern)) {
            formatPattern = DATE_FORMAT_DATELONG;
        } else if ("YYYYMMDDMMSS".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyyMMddmmss";
        } else if ("YYYYMMDDHH".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyyMMddHH";
        } else if ("YYYYMMDDHHSS".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyyMMddHHSS";
        } else if ("YYYYMMDDHHMM".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyyMMddHHmm";
        } else if ("YYYYMMDDHHMMSS".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyyyMMddHHmmss";
        } else if ("YY-MM".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yy-MM";
        } else if ("YYMM".equalsIgnoreCase(formatPattern)) {
            formatPattern = "yyMM";
        }
        return formatPattern;
    }

    public static int betweenYears(Object startDate, Object endDate) throws Throwable {
        LocalDateTime startLocalDate = ERPDateUtil.toLocalDateTime(startDate);
        LocalDateTime endLocalDate = ERPDateUtil.toLocalDateTime(endDate);
        return endLocalDate.getYear() - startLocalDate.getYear();
    }

    public static int betweenDays(Object startDate, Object endDate) throws Throwable {
        Duration duration = ERPDateUtil.getDuration(startDate, endDate);
        long days = duration.toDays();
        return (int)days;
    }

    public static int betweenHours(Object startDate, Object endDate) throws Throwable {
        Duration duration = ERPDateUtil.getDuration(startDate, endDate);
        long hours = duration.toHours();
        return (int)hours;
    }

    public static int betweenMinutes(Object startDate, Object endDate) throws Throwable {
        Duration duration = ERPDateUtil.getDuration(startDate, endDate);
        long minutes = duration.toMinutes();
        return (int)minutes;
    }

    public static int getYear(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        int value = localDateTime.getYear();
        return value;
    }

    public static int getMonth(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        int value = localDateTime.getMonthValue();
        return value;
    }

    public static int getDay(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        int value = localDateTime.getDayOfMonth();
        return value;
    }

    public static int getWeekDay(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        DayOfWeek dayOfWeek = localDateTime.getDayOfWeek();
        if (dayOfWeek == DayOfWeek.SUNDAY) {
            return 1;
        }
        int value = dayOfWeek.getValue();
        return value + 1;
    }

    public static int getHour(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        int value = localDateTime.getHour();
        return value;
    }

    public static int getMinute(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        int value = localDateTime.getMinute();
        return value;
    }

    public static int getSecond(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        int value = localDateTime.getSecond();
        return value;
    }

    public static boolean isBefore(Object startDate, Object endDate) {
        if (startDate.equals(endDate)) {
            return true;
        }
        LocalDateTime startLocalDate = ERPDateUtil.toLocalDateTime(startDate);
        LocalDateTime endLocalDate = ERPDateUtil.toLocalDateTime(endDate);
        boolean before = startLocalDate.isBefore(endLocalDate);
        return before;
    }

    public static Long getFirstDayOfYear(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        LocalDateTime firstDayOfYear = localDateTime.with(TemporalAdjusters.firstDayOfYear());
        return ERPDateUtil.toDateLong(firstDayOfYear);
    }

    public static Long getLastDayOfYear(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        LocalDateTime lastDayOfYear = localDateTime.with(TemporalAdjusters.lastDayOfYear());
        return ERPDateUtil.toDateLong(lastDayOfYear);
    }

    public static Long getFirstDayOfMonth(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        LocalDateTime firstDayOfMonth = localDateTime.with(TemporalAdjusters.firstDayOfMonth());
        return ERPDateUtil.toDateLong(firstDayOfMonth);
    }

    public static Long getLastDayOfMonth(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        LocalDateTime lastDayOfMonth = localDateTime.with(TemporalAdjusters.lastDayOfMonth());
        return ERPDateUtil.toDateLong(lastDayOfMonth);
    }

    public static Long getFirstDayOfWeek(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        LocalDateTime monday = localDateTime.with(DayOfWeek.MONDAY);
        return ERPDateUtil.toDateLong(monday);
    }

    public static Long getLastDayOfWeek(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        LocalDateTime sunday = localDateTime.with(DayOfWeek.SUNDAY);
        return ERPDateUtil.toDateLong(sunday);
    }

    public static int getWeekOfYear(Object date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        WeekFields weekFields = WeekFields.of(DayOfWeek.MONDAY, 1);
        return localDateTime.get(weekFields.weekOfYear());
    }

    public static int getYearMonth(java.util.Date date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        int year = localDateTime.getYear();
        int month = localDateTime.getMonthValue();
        return year * 100 + month;
    }

    public static int getYearMonth(Long date) {
        LocalDateTime localDateTime = ERPDateUtil.toLocalDateTime(date);
        int year = localDateTime.getYear();
        int month = localDateTime.getMonthValue();
        return year * 100 + month;
    }

    public static Long getTimeLong() {
        return ERPDateUtil.toTimeLong(ERPDateUtil.now());
    }

    public static Long dayToStartTime(Long dateTime) {
        if (dateTime.toString().length() == 14) {
            return dateTime;
        }
        String s = dateTime + "000000";
        return Long.parseLong(s);
    }

    public static Long dayToFinishTime(Long dateTime) {
        if (dateTime.toString().length() == 14) {
            return dateTime;
        }
        String s = dateTime + "235959";
        return Long.parseLong(s);
    }

    public static Long timeToDay(Long dateTime) {
        if (dateTime.toString().length() == 8) {
            return dateTime;
        }
        String s = dateTime.toString();
        String s1 = s.substring(0, s.length() - 6);
        return Long.parseLong(s1);
    }

    public static java.util.Date longToDate(Long dateTime) throws ParseException {
        java.util.Date date;
        String s = dateTime.toString();
        if (s.equals("0")) {
            return null;
        }
        if (s.length() <= 8) {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_DATELONG);
            date = sdf.parse(s);
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            date = sdf.parse(s);
        }
        return date;
    }

    public static Long dateToLong(java.util.Date dateTime) throws ParseException {
        if (dateTime == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DATELONG);
        String dateStr = format.format(dateTime);
        return Long.parseLong(dateStr);
    }

    public static Long dateToLong(LocalDateTime dateTime) throws ParseException {
        if (dateTime == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_DATELONG);
        String dateStr = format.format(dateTime);
        return Long.parseLong(dateStr);
    }

    public static Long dateToLong(java.util.Date dateTime, String formatStr) throws ParseException {
        if (dateTime == null) {
            return null;
        }
        if (formatStr.equals("")) {
            formatStr = DATE_FORMAT_DATELONG;
        }
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        String dateStr = format.format(dateTime);
        return Long.parseLong(dateStr);
    }

    public static Long dateToLong(LocalDateTime dateTime, String formatStr) throws ParseException {
        if (dateTime == null) {
            return null;
        }
        if (formatStr.equals("")) {
            formatStr = DATE_FORMAT_DATELONG;
        }
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        String dateStr = format.format(dateTime);
        return Long.parseLong(dateStr);
    }

    public static LocalDate longToLocalDate(Long currentDate) throws ParseException {
        if (TypeConvertor.toString((Object)currentDate).length() != 8) {
            throw new IllegalArgumentException();
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATE_FORMAT_DATELONG);
        return LocalDate.parse(TypeConvertor.toString((Object)currentDate), formatter);
    }
}

