/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.util;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ByteUtil {
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    private static final String SEC_TYPE = "SHA-1";

    public static byte[] toBytes(Serializable obj) throws Throwable {
        if (obj == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream dos = new ObjectOutputStream(baos);
        byte[] bytes = null;
        try {
            dos.writeObject(obj);
            bytes = baos.toByteArray();
        }
        finally {
            dos.close();
            baos.close();
        }
        return bytes;
    }

    private static final String security2HexString(byte[] info, String type, String pref, String latf) throws NoSuchAlgorithmException {
        if (type == null) {
            type = SEC_TYPE;
        }
        MessageDigest alga = MessageDigest.getInstance(type);
        alga.update(info);
        byte[] digest = alga.digest();
        return ByteUtil.toHexString(digest, pref, latf);
    }

    private static final String toHexString(byte[] b, String pref, String latf) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < b.length) {
            sb.append(pref).append(Integer.toHexString(b[i] < 0 ? b[i] + 256 : b[i])).append(latf);
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    public static final String security2HexString(String info) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return ByteUtil.security2HexString(info.getBytes("UTF-8"), "MD5", "", "");
    }

    public static boolean toBoolean(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Array has wrong size: " + b.length);
        }
        return b[0] != 0;
    }

    public static double toDouble(byte[] bytes) throws Throwable {
        return ByteUtil.toDouble(bytes, 0);
    }

    private static double toDouble(byte[] bytes, int offset) throws Throwable {
        return Double.longBitsToDouble(ByteUtil.toLong(bytes, offset, 8));
    }

    private static Long toLong(byte[] bytes, int offset, int length) throws Exception {
        if (length != 8 || offset + length > bytes.length) {
            throw new Exception("toLong\u8f6c\u6362\u5931\u8d25");
        }
        Long l = 0L;
        int i = offset;
        while (i < offset + length) {
            l = l << 8;
            l = l ^ (long)(bytes[i] & 0xFF);
            ++i;
        }
        return l;
    }
}

