/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.erp.lock;

import com.bokesoft.yes.common.util.DebugUtil;
import com.bokesoft.yes.mid.util.PropertyUtil;
import java.io.InputStream;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;

public class ServerUtil {
    private static int serverPort;

    public static String getMacAddress() throws Throwable {
        ArrayList<String> wiredIPs = new ArrayList<String>();
        ArrayList<String> wirelessIPs = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            block2: while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                if (networkInterface.isLoopback() || networkInterface.isVirtual() || networkInterface.isPointToPoint() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                boolean isWiredNetwork = ServerUtil.isWiredNetwork(networkInterface);
                boolean isWirelessNetwork = ServerUtil.isWirelessNetwork(networkInterface);
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    if (inetAddress instanceof Inet6Address || !inetAddress.isReachable(10000)) continue;
                    String macAddress = ServerUtil.getLocalMac(networkInterface);
                    if (isWiredNetwork) {
                        wiredIPs.add(macAddress);
                        continue block2;
                    }
                    if (!isWirelessNetwork) continue block2;
                    wirelessIPs.add(macAddress);
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            DebugUtil.debug((Object)e.getMessage());
        }
        String result = wiredIPs.size() == 1 ? (String)wiredIPs.get(0) : (wirelessIPs.size() == 1 ? (String)wirelessIPs.get(0) : ServerUtil.getCoreAttribute("core.properties", "MACADDRESS"));
        if (result == null || result.length() == 0) {
            throw new RuntimeException("\u53d6\u5e94\u7528\u670d\u52a1\u5668\u7684MAC\u5730\u5740\u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
        return result;
    }

    private static String getLocalMac(NetworkInterface networkInterface) throws SocketException {
        byte[] mac = networkInterface.getHardwareAddress();
        StringBuilder sb = new StringBuilder(20);
        int i = 0;
        while (i < mac.length) {
            int temp;
            String str;
            if (i != 0) {
                sb.append("-");
            }
            if ((str = Integer.toHexString(temp = mac[i] & 0xFF)).length() == 1) {
                sb.append("0" + str);
            } else {
                sb.append(str);
            }
            ++i;
        }
        return sb.toString().toUpperCase();
    }

    private static boolean isWiredNetwork(NetworkInterface networkInterface) {
        boolean isHyperV;
        String name = networkInterface.getName();
        boolean isWiredNetwork = name != null && (name.startsWith("eth") || name.startsWith("eno") || name.startsWith("enp"));
        String displayName = networkInterface.getDisplayName();
        boolean isVMware = displayName != null && displayName.contains("VMware");
        boolean bl = isHyperV = displayName != null && displayName.contains("Hyper-V");
        return isWiredNetwork && !isVMware && !isHyperV;
    }

    private static boolean isWirelessNetwork(NetworkInterface networkInterface) {
        String name = networkInterface.getName();
        return name != null && name.startsWith("wlan");
    }

    public static String getCoreAttribute(String fileName, String attributeKey) throws Throwable {
        try (InputStream coreIs = null;){
            String attributeValue;
            coreIs = PropertyUtil.readProperties((String)fileName);
            PropertyResourceBundle coreBundle = new PropertyResourceBundle(coreIs);
            String string = attributeValue = coreBundle.getString(attributeKey).trim();
            return string;
        }
        return "";
    }

    public static int getServerPort() {
        return serverPort;
    }

    public static void setServerPort(int serverPort) {
        ServerUtil.serverPort = serverPort;
    }
}

