/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.performance.trace;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.erp.performance.trace.TraceFormula;
import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.struct.env.Env;

public class TraceSetting {
    private boolean isTraceFormula = false;
    private boolean isJustRecordFormulaError = false;
    public static boolean isTraceService = true;
    public static boolean isTraceSQL = true;
    private static final String STR_TraceSetting = "TraceSetting";

    public static boolean isTraceFormula(IServiceContext context) {
        Env env = context.getVE().getEnv();
        TraceSetting setting = (TraceSetting)env.get(STR_TraceSetting);
        if (setting == null) {
            return false;
        }
        return setting.isTraceFormula;
    }

    public static int getOperatingEnvironment(IServiceContext context) {
        String curClientID = context.getVE().getEnv().getClientID();
        int mode = context.getVE().getEnv().getMode();
        ISessionInfoProvider pcProvider = SessionInfoProviderHolder.getProvider((int)mode);
        if (pcProvider == null) {
            return 1;
        }
        SessionInfo pcSessionInfo = (SessionInfo)pcProvider.getSessionInfoMap().get(curClientID);
        return pcSessionInfo.getOperatingEnvironment();
    }

    public static boolean isJustRecordFormulaError(IServiceContext context) {
        Env env = context.getVE().getEnv();
        TraceSetting setting = (TraceSetting)env.get(STR_TraceSetting);
        if (setting == null) {
            return false;
        }
        return setting.isJustRecordFormulaError;
    }

    public static void setRunInDesignMode(IServiceContext context, boolean isInDesignMode) {
        Env env = context.getVE().getEnv();
        TraceSetting setting = (TraceSetting)env.get(STR_TraceSetting);
        if (isInDesignMode) {
            if (setting == null) {
                setting = new TraceSetting();
                env.put(STR_TraceSetting, (Object)setting);
            }
            setting.isTraceFormula = true;
            setting.isJustRecordFormulaError = true;
        } else {
            env.getSessionParas().remove(STR_TraceSetting);
        }
    }

    public static String getError(TraceFormula formula, Throwable e) {
        String message = e.getMessage();
        String stackTrace = Performance.getStackTraceString(formula);
        return String.valueOf(message) + "\n" + stackTrace;
    }
}

