/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.performance;

import com.bokesoft.erp.performance.Action;
import com.bokesoft.erp.performance.trace.ITraceObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionRecorder {
    List<Action> actions = new ArrayList<Action>();
    Stack<Action> stack = new Stack();
    long lastTime;
    private static final Logger logger = LoggerFactory.getLogger(ActionRecorder.class);

    public int startAction(Object action) {
        Action parent = this.stack.isEmpty() ? null : this.stack.peek();
        Action newAction = new Action(action, parent, this.lastTime);
        this.lastTime = newAction.startTime;
        this.actions.add(newAction);
        this.stack.push(newAction);
        return this.actions.size() - 1;
    }

    public void startSubAction(int action, String info) {
        Action parent = this.actions.get(action);
        if (this.stack.peek() != parent) {
            this.stack.pop();
            if (this.stack.peek() != parent) {
                throw new RuntimeException("\u6808\u5185\u5bb9\u4e0d\u5bf9");
            }
        }
        Action subAction = parent.startSubAction(info, this.lastTime);
        this.lastTime = subAction.startTime;
        this.actions.add(subAction);
        this.stack.push(subAction);
    }

    public void endActive(int action) {
        Action pop;
        Action curAction = this.actions.get(action);
        while ((pop = this.stack.pop()) != curAction) {
            pop.endAction();
        }
        this.lastTime = curAction.endAction();
    }

    private void calcSelfRunTime() {
        for (Action action : this.actions) {
            if (action == null) continue;
            action.setSelfTime(action.getRunTime());
            Action parent = action.parent;
            if (parent == null) continue;
            parent.setSelfTime(parent.getSelfTime() - action.getRunTime());
        }
    }

    public String getString() {
        this.calcSelfRunTime();
        StringBuilder sb = new StringBuilder(262144);
        sb.append("\n================================================================================");
        sb.append("\nLevel\tTime(0.001ms)\tSelfTime(0.001ms)\tGapTime(0.001ms)\tAction\n");
        for (Action action : this.actions) {
            int i = 0;
            while (i < action.level) {
                sb.append(" ");
                ++i;
            }
            sb.append(action.level).append("\t").append(action.getRunTime() / 1000L).append("\t").append(action.getSelfTime() / 1000L).append("\t").append(action.gapTime / 1000L).append("\t").append(action.name);
            sb.append("\n");
        }
        sb.append("================================================================================");
        return sb.toString();
    }

    private void clear() {
        this.actions.clear();
        this.stack.clear();
    }

    public void printLog(int actionIndex) {
        if (logger.isInfoEnabled() && this.actions.size() > 1) {
            this.calcSelfRunTime();
            StringBuilder sb = new StringBuilder(263168);
            sb.append("\n================================================================================");
            sb.append("\nLevel\tTime(0.001ms)\tSelfTime(0.001ms)\tGapTime(0.001ms)\tAction\n");
            int index = Math.max(actionIndex - 1, 0);
            while (index < this.actions.size()) {
                Action action;
                if ((actionIndex == -1 || index >= actionIndex) && (action = this.actions.get(index)) != null) {
                    int i = 0;
                    int size = action.level;
                    while (i < size) {
                        sb.append(" ");
                        ++i;
                    }
                    sb.append(action.level).append("\t").append(action.getRunTime() / 1000L).append("\t").append(action.getSelfTime() / 1000L).append("\t").append(action.gapTime / 1000L).append("\t").append(action.name);
                    sb.append("\n");
                    if (sb.length() > 262144) {
                        logger.info(sb.toString());
                        sb.setLength(0);
                        sb.append("\n");
                    }
                    if (actionIndex != -1 && index >= actionIndex) {
                        this.actions.set(index, null);
                    }
                }
                ++index;
            }
            sb.append("================================================================================");
            logger.info(sb.toString());
        }
        if (actionIndex == -1) {
            this.clear();
        }
    }

    public String getStackTraceString(ITraceObject formula) {
        int curIndex = this.stack.size() - 1;
        while (curIndex >= 0) {
            if (((Action)this.stack.get((int)curIndex)).name == formula) break;
            --curIndex;
        }
        StringBuilder result = new StringBuilder(1024);
        result.append(formula);
        int i = curIndex - 1;
        while (i >= 0) {
            Object name = ((Action)this.stack.get((int)i)).name;
            if (name instanceof ITraceObject) {
                result.append("\n").append(name);
            }
            --i;
        }
        return result.toString();
    }
}

