/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.metaobjectchange;

import com.bokesoft.erp.metaobjectchange.IMetaObjectChangeListener;
import com.bokesoft.erp.metaobjectchange.MetaObjectChangeListener;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MetaObjectChange {
    private static List<IMetaObjectChangeListener> listeners = new ArrayList<IMetaObjectChangeListener>();

    public static void register(MetaObjectChangeListener listener, String group) {
        listener.setGroup(group);
        listeners.add(listener);
    }

    public static void fireChangeMetaForm(MetaForm metaForm) throws Throwable {
        for (IMetaObjectChangeListener l : listeners) {
            l.changeMetaForm(metaForm);
        }
    }

    public static void fireBatchChangeMetaForm(CopyOnWriteArrayList<MetaForm> metaForms) throws Throwable {
        for (IMetaObjectChangeListener l : listeners) {
            l.batchChangeMetaForm(metaForms);
        }
    }

    public static void fireChangeDesignMetaForm(MetaForm metaForm, String ... groups) throws Throwable {
        for (IMetaObjectChangeListener l : listeners) {
            if (l.getGroup().equals("TableCacheAll")) {
                if (groups.length != 0 && !Arrays.asList(groups).contains("TableCacheAll")) continue;
                if (metaForm == null || metaForm.getDataSource() == null || metaForm.getDataSource().getDataObject() == null) {
                    return;
                }
                l.clearTableCache(metaForm.getDataSource().getDataObject());
                continue;
            }
            if (groups.length != 0 && !Arrays.asList(groups).contains(l.getGroup())) continue;
            l.changeMetaForm(metaForm);
        }
    }

    public static void fireChangeDesignMetaDataObject(MetaDataObject metaDataObject, String ... groups) throws Throwable {
        for (IMetaObjectChangeListener l : listeners) {
            if (l.getGroup().equals("TableCacheAll")) {
                if (groups.length != 0 && !Arrays.asList(groups).contains("TableCacheAll")) continue;
                l.clearTableCache(metaDataObject);
                continue;
            }
            if (groups.length != 0 && !Arrays.asList(groups).contains(l.getGroup())) continue;
            l.changeMetaDataObject(metaDataObject);
        }
    }

    public static void fireChangeMetaDataObject(MetaDataObject metaDataObject) throws Throwable {
        for (IMetaObjectChangeListener l : listeners) {
            l.changeMetaDataObject(metaDataObject);
        }
    }

    public static void fireChangeAll() {
        for (IMetaObjectChangeListener l : listeners) {
            l.changeMetaAll();
        }
    }
}

