/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.io.handler;

import com.bokesoft.erp.dictionary.OrganizationDataIdentity;
import com.bokesoft.erp.io.util.ExcelTemplateUtil;
import com.bokesoft.yes.mid.cmd.richdocument.strut.IDLookup;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.util.ERPDateUtil;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.file.provider.IAttachmentProvider;
import com.bokesoft.yigo.mid.file.util.AttachmentUtil;
import com.bokesoft.yigo.tools.ve.VE;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelImportExportLogUtil {
    private static final Logger logger = LoggerFactory.getLogger(ExcelImportExportLogUtil.class);
    private static final int DEFAULT_CHUNK_SIZE = 0x500000;
    private static final String tempDirPath = System.getProperty("java.io.tmpdir");
    private static volatile ExcelImportExportLogUtil instance = null;
    private Map<String, String> a = new ConcurrentHashMap<String, String>();
    private Map<String, StringBuffer> b = new ConcurrentHashMap<String, StringBuffer>();
    private Map<String, Path> c = new ConcurrentHashMap<String, Path>();

    private ExcelImportExportLogUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExcelImportExportLogUtil getInstance() {
        if (instance != null) return instance;
        Class<ExcelImportExportLogUtil> clazz = ExcelImportExportLogUtil.class;
        synchronized (ExcelImportExportLogUtil.class) {
            ExcelImportExportLogUtil excelImportExportLogUtil;
            if (instance != null) return instance;
            instance = excelImportExportLogUtil = new ExcelImportExportLogUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void remove(String string) {
        this.a.remove(string);
        this.b.remove(string);
        this.c.remove(string);
    }

    private StringBuffer a(RichDocumentContext richDocumentContext, String string, String string2) {
        String string3 = richDocumentContext.getDefaultContext().getEnv().getClientID();
        StringBuffer stringBuffer = null;
        if (this.b.containsKey(string3)) {
            stringBuffer = this.b.get(string3);
        } else {
            stringBuffer = new StringBuffer();
            this.b.put(string3, stringBuffer);
        }
        if (stringBuffer.length() > 10000) {
            this.a(string, string3, stringBuffer);
            stringBuffer.setLength(0);
            stringBuffer.trimToSize();
        }
        String string4 = ERPDateUtil.format((Object)ERPDateUtil.getNowTime(), (String)"yyyy-MM-dd HH:mm:ss");
        stringBuffer.append("[").append(string4).append("] ->").append(string2).append("\r\n");
        return stringBuffer;
    }

    private StringBuffer a(RichDocumentContext richDocumentContext, String string, String string2, StringBuffer stringBuffer) {
        String string3 = richDocumentContext.getDefaultContext().getEnv().getClientID();
        StringBuffer stringBuffer2 = null;
        if (this.b.containsKey(string3)) {
            stringBuffer2 = this.b.get(string3);
        } else {
            stringBuffer2 = new StringBuffer();
            this.b.put(string3, stringBuffer2);
        }
        if (stringBuffer2.length() > 10000) {
            this.a(string, string3, stringBuffer2);
            stringBuffer2.setLength(0);
            stringBuffer2.trimToSize();
        }
        String string4 = ERPDateUtil.format((Object)ERPDateUtil.getNowTime(), (String)"yyyy-MM-dd HH:mm:ss");
        stringBuffer2.append("[").append(string4).append("] ->").append(string2).append("\r\n");
        stringBuffer.append("[").append(string4).append("] ->").append(string2).append("\r\n");
        return stringBuffer2;
    }

    public void success(RichDocumentContext richDocumentContext, String string, String string2) {
        this.a(richDocumentContext, string, string2);
        logger.info(string2);
    }

    public void success(RichDocumentContext richDocumentContext, String string, String string2, StringBuffer stringBuffer) {
        this.a(richDocumentContext, string, string2, stringBuffer);
        logger.info(string2);
    }

    public void error(RichDocumentContext richDocumentContext, String string, String string2, Throwable throwable) {
        StringBuffer stringBuffer = this.a(richDocumentContext, string, string2);
        logger.error(string2, throwable);
        if (throwable == null) {
            return;
        }
        String string3 = ERPDateUtil.format((Object)ERPDateUtil.getNowTime(), (String)"yyyy-MM-dd HH:mm:ss");
        stringBuffer.append("[").append(string3).append("] -> ").append(throwable.getMessage()).append("\r\n");
    }

    public void error(RichDocumentContext richDocumentContext, String string, String string2, Throwable throwable, StringBuffer stringBuffer) throws Exception {
        this.a(richDocumentContext, string, string2, stringBuffer);
        logger.error(string2, throwable);
        throw new Exception(string2);
    }

    public String save2LogFile(RichDocumentContext richDocumentContext, String string, StringBuffer stringBuffer) throws Throwable {
        String string2;
        boolean bl;
        MetaForm metaForm = richDocumentContext.getMetaFactory(false).getMetaForm(string);
        String string3 = richDocumentContext.getDefaultContext().getEnv().getClientID();
        boolean bl2 = IDLookup.isDict((MetaForm)metaForm);
        OrganizationDataIdentity[] organizationDataIdentityArray = ExcelTemplateUtil.getOrganizationDatas(richDocumentContext, string);
        boolean bl3 = bl = bl2 && organizationDataIdentityArray != null && organizationDataIdentityArray.length > 0;
        if (bl2 && !bl || IDLookup.isCompDict((MetaForm)metaForm)) {
            string2 = this.save2LogFile(richDocumentContext, string, stringBuffer, string3);
        } else {
            stringBuffer = this.b.get(string3);
            string2 = this.save2LogFile(richDocumentContext, string, stringBuffer, string3);
        }
        return string2;
    }

    public String save2LogFile(RichDocumentContext richDocumentContext, String string, StringBuffer stringBuffer, String string2) throws Throwable {
        String string3;
        Path path = this.a(string, string2, stringBuffer);
        if (stringBuffer != null && stringBuffer.length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.trimToSize();
        }
        long l = System.currentTimeMillis();
        String string4 = ERPDateUtil.format((Object)l, (String)"yyyyMMddHHmmss");
        String string5 = String.valueOf(string) + "-" + string4 + ".log";
        String string6 = "Operator";
        String string7 = "Temp";
        long l2 = Files.size(path);
        if (l2 > 0x6400000L) {
            logger.debug(">>>> \u6587\u4ef6 {} \u5927\u5c0f\u4e3a {}\uff0c \u5206\u7247\u4e0a\u4f20", (Object)path, (Object)l2);
            string3 = this.a(richDocumentContext, path, string5, string6, l, string7);
        } else {
            IAttachmentProvider iAttachmentProvider = AttachmentUtil.newProvider((String)"", (VE)richDocumentContext.getVE());
            byte[] byArray = Files.readAllBytes(path);
            string3 = iAttachmentProvider.upload((DefaultContext)richDocumentContext, string5, string6, l, "", string7, byArray, false);
        }
        this.b.remove(string2);
        this.a.put(string2, string3);
        logger.debug(">>>> \u751f\u6210\u65e5\u5fd7\u6587\u4ef6 {} - {}", (Object)string2, (Object)string3);
        return string3;
    }

    /*
     * Unable to fully structure code
     */
    private String a(RichDocumentContext var1_1, Path var2_2, String var3_3, String var4_4, long var5_5, String var7_6) throws Throwable {
        var8_7 = 0x500000;
        var10_8 = AttachmentUtil.newProvider((String)"", (VE)var1_1.getVE());
        var11_9 = null;
        var12_11 = null;
        try {
            var13_13 = new RandomAccessFile(var2_2.toFile(), "rw");
            try {
                var14_14 = var13_13.length();
                var16_15 = (int)((var14_14 + (long)var8_7 - 1L) / (long)var8_7);
                var17_16 = 0;
                while (true) {
                    var18_18 = var17_16 + 1;
                    var19_19 = (long)var17_16 * (long)var8_7;
                    var21_20 = var17_16 == var16_15 - 1 ? (int)(var14_14 - var19_19) : var8_7;
                    var22_21 = new byte[var21_20];
                    var13_13.seek(var19_19);
                    var13_13.read(var22_21);
                    var9_17 = var10_8.uploadLarge((DefaultContext)var1_1, var3_3, var4_4, var5_5, var7_6, var22_21, var8_7, var18_18, var14_14);
                    if (var9_17 != null) {
                        return var9_17;
                    }
                    ++var17_16;
                    return var17_16;
                }
            }
            finally {
                if (var17_16 < var16_15) ** continue;
            }
        }
        catch (Throwable var12_12) {
            if (var11_9 == null) {
                var11_9 = var12_12;
            } else if (var11_9 != var12_12) {
                var11_9.addSuppressed(var12_12);
            }
            throw var11_9;
        }
        return null;
    }

    private Path a(String string, String string2, StringBuffer stringBuffer) {
        Path path = this.c.computeIfAbsent(string2, string3 -> {
            long l = System.currentTimeMillis();
            String string4 = String.valueOf(string) + "-" + string2 + "-" + l + ".log";
            return Paths.get(tempDirPath, string4);
        });
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.write(path, stringBuffer.toString().getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
        }
        catch (Exception exception) {
            logger.debug("\u6587\u4ef6\u64cd\u4f5c\u5931\u8d25: " + exception.getMessage());
        }
        return path;
    }
}

