/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.erp.dataInterface;

import com.bokesoft.yes.util.ERPStringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RessionConfig {
    private static Logger logger = LoggerFactory.getLogger(RessionConfig.class);
    private static Map<String, RedissonClient> redissonClientMap = new ConcurrentHashMap<String, RedissonClient>();
    private static String redisHost;
    private static String redisPort;
    private static String redisPassword;

    public static String getRedisHost() {
        return redisHost;
    }

    public static void setRedisHost(String string) {
        redisHost = string;
    }

    public static String getRedisPort() {
        return redisPort;
    }

    public static void setRedisPort(String string) {
        redisPort = string;
    }

    public static String getRedisPassword() {
        return redisPassword;
    }

    public static void setRedisPassword(String string) {
        redisPassword = string;
    }

    public static synchronized RedissonClient redissonClient() {
        String string = redisHost.concat(redisPort);
        if (!redissonClientMap.containsKey(string)) {
            try {
                Config config = new Config();
                ((SingleServerConfig)config.useSingleServer().setAddress("redis://" + redisHost + ":" + redisPort).setPassword(ERPStringUtil.isBlankOrNull((Object)redisPassword) ? null : redisPassword)).setDatabase(0);
                RedissonClient redissonClient = Redisson.create((Config)config);
                redissonClientMap.put(string, redissonClient);
            }
            catch (Exception exception) {
                logger.error("RedissonClient\u521b\u5efa\u5f02\u5e38", (Throwable)exception);
            }
        }
        return redissonClientMap.get(string);
    }
}

