/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.deployment.resource;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.ResourceMultiSolutionResolver;
import com.bokesoft.distro.tech.yigosupport.deployment.resource.intf.IResourceIO;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.factory.IMetaResolverFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResourceMultiSolutionMetaResolverFactory
implements IMetaResolverFactory {
    private static final Logger log = LoggerFactory.getLogger(AbstractResourceMultiSolutionMetaResolverFactory.class);
    private static final char SEPARATOR = "/".charAt(0);
    private IResourceIO resourceIO;
    private List<String> resources;

    protected abstract IResourceIO getResourceIO();

    public void initParas(Map<String, Object> paras) {
        try {
            this.resourceIO = this.getResourceIO();
            this.resources = this.resourceIO.list();
        }
        catch (IOException e) {
            throw MiscUtil.toRuntimeException((Throwable)e);
        }
    }

    public String getSolutionPath() {
        try {
            Path path = Files.createTempDirectory(this.getClass().getName() + "-", new FileAttribute[0]);
            File tmpDir = path.toFile();
            FileUtils.forceMkdir((File)tmpDir);
            String tmp = tmpDir.getCanonicalPath();
            log.warn("\u4e0d\u5efa\u8bae\u4f7f\u7528\u7684 API \u8c03\u7528: getSolutionPath return '{}'", (Object)tmp);
            return tmp;
        }
        catch (IOException e) {
            throw MiscUtil.toRuntimeException((Throwable)e);
        }
    }

    public IMetaResolver newMetaResolver(String prefix) {
        ResourceMultiSolutionResolver resolver = new ResourceMultiSolutionResolver(this.resources, this.resourceIO, prefix);
        log.info("create newMetaResolver [{}]: prefix='{}' .", (Object)Integer.toHexString(resolver.hashCode()), (Object)prefix);
        return resolver;
    }

    public IMetaResolver newFileMetaResolver(String prefix) {
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u901a\u8fc7\u7edd\u5bf9\u76ee\u5f55\u7684\u5f15\u7528(prefix='" + prefix + "')");
    }

    public char getSeparator() {
        return SEPARATOR;
    }
}

