/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.yigosupport.deployment.local;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMultiSolutionMetaResolver
implements IMetaResolver {
    private static final Logger log = LoggerFactory.getLogger(LocalMultiSolutionMetaResolver.class);
    private static final String FILE_SPILTER = "/";
    private String prefix;
    private String fullBasePath;

    public LocalMultiSolutionMetaResolver(String baseDir, String prefix) {
        MiscUtil.$assert((null == baseDir ? 1 : 0) != 0, (String)"\u6784\u9020 IMetaResolver \u5931\u8d25 - baseDir \u4e3a\u7a7a");
        MiscUtil.$assert((null == prefix ? 1 : 0) != 0, (String)"\u6784\u9020 IMetaResolver \u5931\u8d25 - prefix \u4e3a\u7a7a");
        this.prefix = prefix;
        this.fullBasePath = LocalMultiSolutionMetaResolver.buildFullPath(baseDir, prefix);
    }

    public boolean isListAbsolutePath() {
        return false;
    }

    public InputStream read(String resource, int type) throws Exception {
        log.debug("[{}] read, prefix|resource='{}|{}', type={}", new Object[]{Integer.toHexString(this.hashCode()), this.prefix, resource, type});
        File f = this.getAbsPath4Resource(resource);
        if (f.isDirectory() || !f.exists()) {
            return null;
        }
        return FileUtils.openInputStream((File)f);
    }

    public URI getURI(String resource, int type) throws Exception {
        log.debug("[{}] getURI, prefix|resource='{}|{}', type={}", new Object[]{Integer.toHexString(this.hashCode()), this.prefix, resource, type});
        File f = this.getAbsPath4Resource(resource);
        if (f.isDirectory() || !f.exists()) {
            return null;
        }
        return f.toURI();
    }

    public boolean write(String resource, byte[] data) throws Exception {
        log.debug("[{}] write, prefix|resource='{}|{}'", new Object[]{Integer.toHexString(this.hashCode()), this.prefix, resource});
        File f = this.getAbsPath4Resource(resource);
        FileUtils.writeByteArrayToFile((File)f, (byte[])data);
        return true;
    }

    public String getPath(String resource) {
        log.debug("[{}] getPath, prefix|resource='{}|{}'", new Object[]{Integer.toHexString(this.hashCode()), this.prefix, resource});
        File f = this.getAbsPath4Resource(resource);
        try {
            return f.getCanonicalPath() + File.separatorChar;
        }
        catch (IOException e) {
            throw MiscUtil.toRuntimeException((Throwable)e);
        }
    }

    public int listResource(String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception {
        log.info("[{}] listResource: prefix|resource='{}|{}', flag={}", new Object[]{Integer.toHexString(this.hashCode()), this.prefix, resource, flag});
        File f = this.getAbsPath4Resource(resource);
        File[] files = f.listFiles();
        if (files != null) {
            int length = files.length;
            File childFile = null;
            for (int i = 0; i < length; ++i) {
                childFile = files[i];
                resources.add(childFile.getName());
                names.add(childFile.getName());
                if (childFile.isDirectory()) {
                    flags.add(true);
                    continue;
                }
                flags.add(false);
            }
        }
        return resources.size();
    }

    public char getSeparator() {
        return '/';
    }

    private File getAbsPath4Resource(String resource) {
        String base = this.fullBasePath;
        MiscUtil.$assert((null == resource ? 1 : 0) != 0, (String)"\u6307\u5b9a\u8d44\u6e90\u4e3a\u7a7a");
        String fullPath = LocalMultiSolutionMetaResolver.buildFullPath(base, resource);
        return new File(fullPath);
    }

    private static String buildFullPath(String base, String path) {
        if (!base.endsWith(FILE_SPILTER)) {
            base = base + FILE_SPILTER;
        }
        if (path.startsWith(FILE_SPILTER)) {
            path = path.substring(1);
        }
        String fullPath = base + path;
        return fullPath;
    }

    public JSONObject readProfile(String resource, int type) throws Exception {
        log.debug("[{}] readProfile, prefix|resource='{}|{}', type={}", new Object[]{Integer.toHexString(this.hashCode()), this.prefix, resource, type});
        return super.readProfile(resource, type);
    }
}

