package com.bokesoft.distro.tech.yigosupport.deployment.resource.utils;

import java.util.ArrayList;
import java.util.List;

import com.bokesoft.distro.tech.yigosupport.deployment.resource.intf.IResourceIO;

/**
 * 处理资源路径的工具, 通过一组路径列表(只有文件)分析和处理目录层次结构. 注意：路径固定使用 "/"({@link IResourceIO#SEPARATOR}) 分割.
 */
public class ResourcePaths {
	private static final String SEPARATOR = IResourceIO.SEPARATOR;
	
	private List<String> paths;

	public ResourcePaths(List<String> paths) {
		this.paths = paths;
	}
	
	public List<String> listFiles(String path){
		List<String> result = new ArrayList<String>();
		
		if (! path.endsWith(SEPARATOR)) {
			path = path+SEPARATOR;
		}
		for(String p: paths) {
			if (! p.startsWith(path)) {
				continue;
			}
			String tail = p.substring(path.length());
			if (! tail.contains(SEPARATOR)){
				result.add(p);
			}
		}
		
		return result;
	}
	
	public List<String> listDirs(String path){
		List<String> result = new ArrayList<String>();
		
		if (! path.endsWith(SEPARATOR)) {
			path = path+SEPARATOR;
		}
		for(String p: paths) {
			if (! p.startsWith(path)) {
				continue;
			}
			String tail = p.substring(path.length());
			int dirIndex = tail.indexOf(SEPARATOR);
			if (dirIndex>=0){
				String subDir = tail.substring(0, dirIndex);
				String subDirPath = path+subDir;
				if (! result.contains(subDirPath)) {
					result.add(subDirPath);
				}
			}
		}
		
		return result;		
	}
}
