/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.trace.utils;

import com.aventrix.jnanoid.jnanoid.NanoIdUtils;
import java.util.Random;

public class TraceTools {
    private static final int ID_SIZE = 16;
    private static final char[] ALPHABET = "0123456789abcdefghijklmnopqrstuvwxyz".toCharArray();

    public static String createNanoId() {
        return NanoIdUtils.randomNanoId((Random)NanoIdUtils.DEFAULT_NUMBER_GENERATOR, (char[])ALPHABET, (int)16);
    }

    public static String calcConsumeLevel(long consumeTime) {
        StringBuilder sb = new StringBuilder();
        sb.append(consumeTime).append("ms");
        if (consumeTime > 100L) {
            sb.append("/TimeCostLevel100ms");
        }
        if (consumeTime > 200L) {
            sb.append("200ms");
        }
        if (consumeTime > 500L) {
            sb.append("500ms");
        }
        if (consumeTime > 1000L) {
            int mathpower = 0;
            TraceTools.calcConsumeLevelbyAlgorism(sb, mathpower, consumeTime /= 1000L);
        }
        return sb.toString();
    }

    private static void calcConsumeLevelbyAlgorism(StringBuilder sb, int mathpower, long consumeTime) {
        if (consumeTime >= 1L) {
            sb.append(Math.round(Math.pow(10.0, mathpower))).append("s");
        }
        if (consumeTime >= 2L) {
            sb.append(2L * Math.round(Math.pow(10.0, mathpower))).append("s");
        }
        if (consumeTime >= 5L) {
            sb.append(5L * Math.round(Math.pow(10.0, mathpower))).append("s");
        }
        if ((consumeTime /= 10L) > 1L) {
            TraceTools.calcConsumeLevelbyAlgorism(sb, ++mathpower, consumeTime);
        }
    }
}

