/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.trace;

import com.bokesoft.distro.tech.commons.basis.data.InstanceNode;
import com.bokesoft.distro.tech.commons.basis.trace.intf.ITraceSupplier;
import com.bokesoft.distro.tech.commons.basis.trace.intf.InstanceInspectable;
import com.bokesoft.distro.tech.commons.basis.trace.utils.TraceTools;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.event.Level;

public class TraceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TraceUtil.class);
    public static final String X_B3_PARENTSPANID = "x-b3-parentspanid";
    public static final String X_B3_TRACEID = "x-b3-traceid";
    public static final String X_B3_SPANID = "x-b3-spanid";
    public static final String X_YES_INSTANCEPATH = "x-yes-instancepath";
    public static final String X_YES_STARTTIME = "x-yes-starttime";
    public static final String X_YES_CONSUMETIME = "x-yes-consumetime";
    private static final String YES_HEADINFOS = "headinfos";
    private static final String YES_SYS_OPT_ID = "Sys_Opt_ID";

    @Deprecated
    public static void wrapFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
        TraceUtil.wrapFilter(request, response, chain, LOGGER, Level.DEBUG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wrapFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Logger logger, Level logLevel) {
        String parentSpanId;
        JSONObject headInfos;
        String headInfoStr;
        String spanId = TraceTools.createNanoId();
        String traceId = "";
        traceId = request.getHeader(X_B3_TRACEID);
        if (StringUtils.isBlank((CharSequence)traceId) && StringUtils.isNotBlank((CharSequence)(headInfoStr = request.getParameter(YES_HEADINFOS))) && !(headInfos = new JSONObject(headInfoStr)).isNull(YES_SYS_OPT_ID)) {
            traceId = headInfos.getString(YES_SYS_OPT_ID);
        }
        if (StringUtils.isBlank((CharSequence)traceId)) {
            traceId = spanId;
        }
        if (StringUtils.isBlank((CharSequence)(parentSpanId = request.getHeader(X_B3_SPANID)))) {
            parentSpanId = spanId;
        }
        MDC.put((String)X_B3_TRACEID, (String)traceId);
        MDC.put((String)X_B3_PARENTSPANID, (String)parentSpanId);
        MDC.put((String)X_B3_SPANID, (String)spanId);
        try {
            TraceUtil.withTraceLog(() -> {
                try {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (IOException | ServletException e) {
                    return ExceptionUtils.rethrow((Throwable)e);
                }
                return null;
            }, request.getRequestURI(), false, logger, logLevel);
        }
        finally {
            MDC.remove((String)X_B3_TRACEID);
            MDC.remove((String)X_B3_PARENTSPANID);
            MDC.remove((String)X_B3_SPANID);
        }
    }

    public static void updateTraceId(String traceId) {
        MDC.put((String)X_B3_TRACEID, (String)traceId);
    }

    public static String getTraceId() {
        return MDC.get((String)X_B3_TRACEID);
    }

    public static String getParentSpanId() {
        return MDC.get((String)X_B3_PARENTSPANID);
    }

    public static String getSpanId() {
        return MDC.get((String)X_B3_SPANID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withTraceLog(ITraceSupplier<T> supplier, Object instance, boolean withNewSpan, Logger processLogger, Level processLogLevel) {
        T t;
        block8: {
            if (null == processLogLevel) {
                processLogLevel = Level.INFO;
            }
            if (null == processLogger) {
                processLogger = LOGGER;
            }
            String oldSpan = null;
            String oldParentSpan = null;
            long insStartTime = System.currentTimeMillis();
            String instancePath = TraceUtil.getInstancePath(instance);
            try {
                if (withNewSpan) {
                    oldSpan = MDC.get((String)X_B3_SPANID);
                    oldParentSpan = MDC.get((String)X_B3_PARENTSPANID);
                    MDC.put((String)X_B3_PARENTSPANID, (String)oldSpan);
                    MDC.put((String)X_B3_SPANID, (String)TraceTools.createNanoId());
                }
                MDC.put((String)X_YES_INSTANCEPATH, (String)instancePath);
                MDC.put((String)X_YES_STARTTIME, (String)String.valueOf(insStartTime));
                TraceUtil.applyLog(processLogger, processLogLevel, "instance [{}] process starting ...", instancePath);
                T result = supplier.get();
                MDC.put((String)X_YES_INSTANCEPATH, (String)instancePath);
                MDC.put((String)X_YES_STARTTIME, (String)String.valueOf(insStartTime));
                long consumeTime = System.currentTimeMillis() - insStartTime;
                String insConsumeLevel = TraceTools.calcConsumeLevel(consumeTime);
                MDC.put((String)X_YES_CONSUMETIME, (String)String.valueOf(consumeTime));
                TraceUtil.applyLog(processLogger, processLogLevel, "instance [{}] process completed, consume time: {}", instancePath, insConsumeLevel);
                t = result;
                if (!withNewSpan) break block8;
            }
            catch (Throwable e) {
                Object object;
                block9: {
                    try {
                        MDC.put((String)X_YES_INSTANCEPATH, (String)instancePath);
                        MDC.put((String)X_YES_STARTTIME, (String)String.valueOf(insStartTime));
                        long consumeTime = System.currentTimeMillis() - insStartTime;
                        String insConsumeLevel = TraceTools.calcConsumeLevel(consumeTime);
                        MDC.put((String)X_YES_CONSUMETIME, (String)String.valueOf(consumeTime));
                        processLogger.error("instance [{}] process error: {}/{}, consume time: {}", new Object[]{instancePath, e.getClass(), e.getMessage(), insConsumeLevel});
                        object = ExceptionUtils.rethrow((Throwable)e);
                        if (!withNewSpan) break block9;
                    }
                    catch (Throwable throwable) {
                        if (withNewSpan) {
                            MDC.put((String)X_B3_PARENTSPANID, oldParentSpan);
                            MDC.put((String)X_B3_SPANID, (String)oldSpan);
                        }
                        MDC.remove((String)X_YES_INSTANCEPATH);
                        MDC.remove((String)X_YES_STARTTIME);
                        MDC.remove((String)X_YES_CONSUMETIME);
                        throw throwable;
                    }
                    MDC.put((String)X_B3_PARENTSPANID, (String)oldParentSpan);
                    MDC.put((String)X_B3_SPANID, (String)oldSpan);
                }
                MDC.remove((String)X_YES_INSTANCEPATH);
                MDC.remove((String)X_YES_STARTTIME);
                MDC.remove((String)X_YES_CONSUMETIME);
                return (T)object;
            }
            MDC.put((String)X_B3_PARENTSPANID, (String)oldParentSpan);
            MDC.put((String)X_B3_SPANID, (String)oldSpan);
        }
        MDC.remove((String)X_YES_INSTANCEPATH);
        MDC.remove((String)X_YES_STARTTIME);
        MDC.remove((String)X_YES_CONSUMETIME);
        return t;
    }

    private static void applyLog(Logger processLogger, Level processLogLevel, String content, String ... logArgs) {
        if (processLogLevel == Level.DEBUG || processLogLevel == Level.TRACE) {
            if (processLogger.isDebugEnabled()) {
                processLogger.debug(content, (Object[])logArgs);
            }
        } else if (processLogLevel == Level.INFO) {
            processLogger.info(content, (Object[])logArgs);
        } else if (processLogLevel == Level.WARN) {
            processLogger.warn(content, (Object[])logArgs);
        } else {
            throw new UnsupportedOperationException("\u5f53\u524d\u65e5\u5fd7\u7ea7\u522b[" + processLogLevel.toString() + "]\u4e0d\u652f\u6301!");
        }
    }

    private static String getInstancePath(Object instance) {
        String result;
        if (instance instanceof InstanceInspectable) {
            InstanceNode instanceNode = ((InstanceInspectable)instance).getInstanceInspectInfo();
            result = TraceUtil.getWholeInstancePath(instanceNode);
        } else {
            if (instance instanceof String) {
                return (String)instance;
            }
            result = instance.getClass().getName() + "@" + Integer.toHexString(instance.hashCode());
        }
        return result;
    }

    private static String getWholeInstancePath(InstanceNode instanceNode) {
        String result = instanceNode.getInstanceId();
        if (null != instanceNode.getParentNode()) {
            result = TraceUtil.getWholeInstancePath(instanceNode.getParentNode()) + "/" + result;
        }
        return result;
    }
}

