/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.jdbc.mssql;

import com.bokesoft.distro.tech.commons.basis.MiscUtil;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.WithItem;
import org.apache.commons.lang3.StringUtils;

public class SQLServerUtils {
    protected static SQLParserResult splitOuterOrderBy(String sql) {
        try {
            Statement stmt = CCJSqlParserUtil.parse((String)sql);
            MiscUtil.$assert(!(stmt instanceof Select), "Unsupported SQL Statement(MUST be SELECT statement): \n" + sql);
            Select selStmt = (Select)stmt;
            SelectBody body = selStmt.getSelectBody();
            if (body instanceof PlainSelect) {
                PlainSelect ps = (PlainSelect)body;
                List orderBy = ps.getOrderByElements();
                if (null == ps.getTop()) {
                    ps.setOrderByElements(null);
                }
                return new SQLParserResult(selStmt, orderBy);
            }
            if (body instanceof SetOperationList) {
                throw new UnsupportedOperationException("UNION,INTERSECT,MINUS,EXCEPT is not supported, use it as subquery: \n" + sql);
            }
            if (body instanceof WithItem) {
                throw new UnsupportedOperationException("WITH clause MUST be a part of a SELECT statement: \n" + sql);
            }
            throw new UnsupportedOperationException("Unknown SELECT SQL: \n" + sql);
        }
        catch (JSQLParserException e) {
            throw MiscUtil.toRuntimeException(e);
        }
    }

    public static String buildCountSqlWithoutOrderBy(String sql, String countColumnName) {
        SQLParserResult pr = SQLServerUtils.splitOuterOrderBy(sql);
        String countSql = "SELECT COUNT(*) AS " + countColumnName + " FROM (" + pr.getSelectSql() + ") ALL_DATA";
        return countSql;
    }

    public static String adaptSqlRange(String sql, int from, int size) {
        try {
            SQLParserResult spr = SQLServerUtils.splitOuterOrderBy(sql);
            List<OrderByElement> orderBy = spr.getOrderBy();
            if (null == orderBy || orderBy.size() <= 0) {
                throw new UnsupportedOperationException("The ranking function 'ROW_NUMBER' must have an ORDER BY clause: \n" + sql);
            }
            for (OrderByElement oe : orderBy) {
                String exp = oe.getExpression().toString();
                if (!StringUtils.isNumeric((CharSequence)exp)) continue;
                throw new UnsupportedOperationException("Windowed functions do not support integer indices as ORDER BY clause expressions: \n" + sql);
            }
            String rownum = "ROW_NUMBER() OVER(" + spr.getOrderBySql() + ")";
            SelectExpressionItem selItem = new SelectExpressionItem(CCJSqlParserUtil.parseExpression((String)rownum));
            selItem.setAlias(new Alias("rownum__$PAGING", true));
            PlainSelect ps = (PlainSelect)spr.getSelectStmt().getSelectBody();
            ps.addSelectItems(new SelectItem[]{selItem});
            String sqlWithRownum = spr.getSelectSql();
            String result = "SELECT * FROM (" + sqlWithRownum + ") AS T__$PAGING WHERE rownum__$PAGING>" + from + " AND rownum__$PAGING<=" + (from + size) + " ORDER BY rownum__$PAGING";
            return result;
        }
        catch (JSQLParserException e) {
            throw MiscUtil.toRuntimeException(e);
        }
    }

    public static class SQLParserResult {
        private Select selectStmt;
        private List<OrderByElement> orderBy;

        public SQLParserResult(Select selectStmt, List<OrderByElement> orderBy) {
            this.selectStmt = selectStmt;
            this.orderBy = orderBy;
        }

        public Select getSelectStmt() {
            return this.selectStmt;
        }

        public List<OrderByElement> getOrderBy() {
            return this.orderBy;
        }

        public String getSelectSql() {
            return this.selectStmt.toString();
        }

        public String getOrderBySql() {
            return PlainSelect.orderByToString(this.orderBy);
        }
    }
}

