/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarSerialFolderManager {
    private static final Logger log = LoggerFactory.getLogger(CalendarSerialFolderManager.class);
    private static final String DATA_FOMART_YYYYMMDD = "yyyy/MM/dd";

    public static String prepareFolder(String basePath) throws IOException {
        return CalendarSerialFolderManager.prepareFolder(basePath, new Date());
    }

    public static String prepareFolder(String basePath, Date date) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat(DATA_FOMART_YYYYMMDD);
        Path folderPath = Paths.get(basePath + "/" + df.format(date), new String[0]);
        FileUtils.forceMkdir((File)folderPath.toFile());
        return folderPath.toAbsolutePath().toString();
    }

    public static void clearExpiredFiles(String basePath, int expiredDays) throws IOException {
        String[] yearFolders;
        File folder = new File(basePath);
        long expiredTimeStamp = CalendarSerialFolderManager.getExpiredTimestamp(expiredDays);
        for (String year : yearFolders = folder.list()) {
            File yearFolder = new File(basePath, year);
            String yearFolderUrl = yearFolder.getAbsolutePath();
            String[] monthFolders = yearFolder.list();
            ArrayList<String> monthFolderList = new ArrayList<String>(Arrays.asList(monthFolders));
            Iterator mit = monthFolderList.iterator();
            while (mit.hasNext()) {
                String month = (String)mit.next();
                File monthFolder = new File(yearFolderUrl, month);
                String monthFolderUrl = monthFolder.getAbsolutePath();
                String[] dayFolders = monthFolder.list();
                ArrayList<String> dayFolderList = new ArrayList<String>(Arrays.asList(dayFolders));
                Iterator dit = dayFolderList.iterator();
                while (dit.hasNext()) {
                    String day = (String)dit.next();
                    File dayFolder = new File(monthFolderUrl, day);
                    long lastmodifyTime = CalendarSerialFolderManager.buildFolderTimestamp(year, month, day);
                    if (lastmodifyTime >= expiredTimeStamp) continue;
                    dit.remove();
                    FileUtils.deleteDirectory((File)dayFolder);
                    log.info("\u65e5\u671f\u76ee\u5f55 [{}] \u5df2\u4fdd\u7559\u8d85\u8fc7 {} \u5929, \u6309\u8fc7\u671f\u5904\u7406, \u5df2\u88ab\u5220\u9664.", (Object)dayFolder.getAbsolutePath(), (Object)expiredDays);
                }
                if (!dayFolderList.isEmpty()) continue;
                mit.remove();
                FileUtils.deleteDirectory((File)monthFolder);
                log.info("\u6708\u4efd\u76ee\u5f55 [{}] \u5df2\u65e0\u5b50\u76ee\u5f55, \u6309\u8fc7\u671f\u5904\u7406, \u5df2\u88ab\u5220\u9664.", (Object)monthFolder.getAbsolutePath(), (Object)expiredDays);
            }
            if (!monthFolderList.isEmpty()) continue;
            FileUtils.deleteDirectory((File)yearFolder);
            log.info("\u5e74\u5ea6\u76ee\u5f55 [{}] \u5df2\u65e0\u5b50\u76ee\u5f55, \u6309\u8fc7\u671f\u5904\u7406, \u5df2\u88ab\u5220\u9664.", (Object)yearFolder.getAbsolutePath(), (Object)expiredDays);
        }
    }

    private static long buildFolderTimestamp(String year, String month, String day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(Integer.valueOf(year), Integer.valueOf(month) - 1, Integer.valueOf(day));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long result = calendar.getTimeInMillis();
        return result;
    }

    private static long getExpiredTimestamp(int expiredDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1 * expiredDays);
        long result = calendar.getTimeInMillis();
        return result;
    }
}

