/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.bgtask;

import java.util.Arrays;
import java.util.stream.Collectors;

public enum EventType {
    START(10, "\u5f00\u59cb"),
    HEARTBEAT(11, "\u5fc3\u8df3"),
    END(20, "\u7ed3\u675f"),
    EXCEPTION(99, "\u5f02\u5e38");

    private final int value;
    private final String caption;

    private EventType(int value, String caption) {
        this.value = value;
        this.caption = caption;
    }

    public int getValue() {
        return this.value;
    }

    public String getCaption() {
        return this.caption;
    }

    public static String getYigoComboBoxItems() {
        return Arrays.stream(EventType.values()).map(a -> String.format("%s,%s", a.value, a.caption)).collect(Collectors.joining(";"));
    }

    public static EventType valueOf(int value) {
        for (EventType a : EventType.values()) {
            if (a.value != value) continue;
            return a;
        }
        return null;
    }
}

