package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database;

import java.io.Serializable;

/**
 * 数据库连接池配置信息
 */
public class DatasourceCfgVO implements Serializable {

    private String jdbcUrl;
    private String jdbcDriver;
    private int initialSize;
    private int minIdle;
    private int maxIdle;
    private long maxWaitMillis;

    public String getJdbcUrl() {
        return jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getJdbcDriver() {
        return jdbcDriver;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public int getInitialSize() {
        return initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public int getMinIdle() {
        return minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxIdle() {
        return maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public long getMaxWaitMillis() {
        return maxWaitMillis;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public DatasourceCfgVO(){
        //JSON 反序列化等场景需要
    }

    public DatasourceCfgVO(String datasourceId, String jdbcUrl, String jdbcDriver, 
                           int initialSize, int minIdle, int maxIdle, long maxWaitMillis) {
        this.jdbcUrl = jdbcUrl;
        this.jdbcDriver = jdbcDriver;
        this.initialSize = initialSize;
        this.minIdle = minIdle;
        this.maxIdle = maxIdle;
        this.maxWaitMillis = maxWaitMillis;
    }

    @Override
    public String toString() {
        return "DatasourceCfgVO [jdbcUrl=" + jdbcUrl + ", jdbcDriver=" + jdbcDriver + ", initialSize=" + initialSize
                + ", minIdle=" + minIdle + ", maxIdle=" + maxIdle + ", maxWaitMillis=" + maxWaitMillis + "]";
    }
}
