package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.bgtask;

import java.util.Arrays;
import java.util.stream.Collectors;

/**
 * quartz Job 事件类型
 */
public enum EventType {
    START(10, "开始"),
    HEARTBEAT(11,"心跳"),
    END(20, "结束"),
    EXCEPTION(99, "异常");

    private final int value;
    private final String caption;

    EventType(int value, String caption) {
        this.value = value;
        this.caption = caption;
    }

    public int getValue() {
        return value;
    }

    public String getCaption() {
        return caption;
    }

    public static String getYigoComboBoxItems() {
        return Arrays.stream(EventType.values())
                .map(a -> String.format("%s,%s", a.value,a.caption))
                .collect(Collectors.joining(";"));
    }

    public static EventType valueOf(int value) {
        for (EventType a : EventType.values()) {
            if (a.value == value) {
                return a;
            }
        }
        return null;
    }

}
