package com.bokesoft.distro.tech.commons.basis.data;

import java.io.Serializable;

/**
 * @author lee
 */
public abstract class BaseResult<T> implements Serializable {
    private static final long serialVersionUID = 1L;

    /** 默认的服务成功代码 */
    protected static final int GENERAL_CODE_SUCCESS = 200;
    protected static final String GENERAL_MSG_SUCCESS = "成功";

    private int code;
    private String message;
    private T data;

    protected boolean success;


    public int getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public T getData() {
        return data;
    }

    public boolean isSuccess() {
        return success;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }



    public void setData(T data) {
        this.data = data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }
}
