/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.io;

import com.bokesoft.distro.tech.commons.basis.io.CalendarSerialFolderManager;
import com.bokesoft.distro.tech.commons.basis.io.internal.FileUnit;
import com.bokesoft.distro.tech.commons.basis.io.internal.LocalFileTempWriter;
import com.bokesoft.distro.tech.commons.basis.io.internal.TempWriterManager;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileTempStorage<T> {
    private static final Logger log = LoggerFactory.getLogger(LocalFileTempStorage.class);
    private String baseDir;
    private Class<T> clazz;
    private String tmpDir;
    private String readyDir;
    private String historyDir;
    private String errDir;
    private LocalFileTempWriter<T> writer;

    private LocalFileTempStorage(String baseDir, Class<T> clazz) {
        this.baseDir = baseDir;
        this.clazz = clazz;
    }

    public static <T> LocalFileTempStorage<T> build(String baseDir, Class<T> clazz) {
        LocalFileTempStorage<T> storage = new LocalFileTempStorage<T>(baseDir, clazz);
        storage.tmpDir = LocalFileTempStorage.getTmpFolder(storage.baseDir, storage.clazz.getName());
        storage.readyDir = LocalFileTempStorage.getReadyFolder(storage.baseDir, storage.clazz.getName());
        storage.historyDir = LocalFileTempStorage.getHistoryFolder(storage.baseDir, storage.clazz.getName());
        storage.errDir = LocalFileTempStorage.getErrorFolder(storage.baseDir, storage.clazz.getName());
        TempWriterManager.bind(clazz, storage.tmpDir, storage.readyDir, storage.errDir);
        return storage;
    }

    public LocalFileTempStorage<T> blockTime(long blockTime) {
        TempWriterManager.modifyBlockTime(this.clazz, blockTime);
        return this;
    }

    public LocalFileTempStorage<T> start() throws IOException {
        FileUtils.forceMkdir((File)new File(this.tmpDir));
        FileUtils.forceMkdir((File)new File(this.readyDir));
        FileUtils.forceMkdir((File)new File(this.historyDir));
        FileUtils.forceMkdir((File)new File(this.errDir));
        TempWriterManager.startMonitor();
        log.info("\u5df2\u542f\u52a8 LocalFileTempStorage: class={}, baseDir={} .", this.clazz, (Object)this.baseDir);
        return this;
    }

    public void save(T value) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u59cb LocalFileTempStorage [{}] \u6570\u636e\u5199\u5165: {} ...", (Object)this.tmpDir, value);
        }
        this.writer = TempWriterManager.getWriter(this.clazz);
        this.writer.writeObject(value);
        if (log.isDebugEnabled()) {
            log.debug("LocalFileTempStorage [{}] \u6570\u636e\u5199\u5165\u5b8c\u6210 .", (Object)this.tmpDir);
        }
    }

    public void save(Collection<T> values) throws IOException {
        for (T value : values) {
            this.save(value);
        }
    }

    public void clearHistoryFile(int expiredDays) throws IOException {
        CalendarSerialFolderManager.clearExpiredFiles(this.historyDir, expiredDays);
    }

    public void doPrepare() throws IOException {
        String[] fileNames = this.getTmpFiles();
        if (null != fileNames && fileNames.length > 0) {
            List<String> activeTmpFiles = TempWriterManager.getActiveTmpFiles();
            LinkedList<String> errorFiles = new LinkedList<String>();
            for (String fileName : fileNames) {
                if (activeTmpFiles.contains(fileName)) continue;
                try {
                    FileUnit.transfTmpFiletoReady(fileName, this.clazz, this.tmpDir, this.readyDir, this.errDir);
                }
                catch (IOException e) {
                    errorFiles.add(fileName);
                }
            }
            if (errorFiles.size() > 0) {
                log.error("\u4ee5\u4e0btmp\u533a\u6587\u4ef6:[" + StringUtils.join(errorFiles, (String)",") + "],\u8fc1\u79fb\u81f3ready\u533a\u5931\u8d25");
            }
        }
    }

    public void consume(DataConsumer<T> consumer) throws IOException {
        String[] fileNames = this.getReadyFiles();
        if (null != fileNames && fileNames.length > 0) {
            for (String fileName : fileNames) {
                if (log.isDebugEnabled()) {
                    log.debug("\u5f00\u59cb LocalFileTempStorage [{}] \u6570\u636e\u5904\u7406: {} ...", (Object)this.tmpDir, (Object)fileName);
                }
                boolean success = false;
                try {
                    List<T> records;
                    File jsonFile = new File(this.readyDir, fileName);
                    if (jsonFile.canRead() && null != (records = LocalFileTempStorage.loadJsonFromFile(jsonFile, this.clazz))) {
                        success = consumer.process(records);
                        if (log.isDebugEnabled()) {
                            log.debug("LocalFileTempStorage [{}] \u6570\u636e\u5904\u7406\u5b8c\u6210: {}, \u7ed3\u679c\u4e3a {} .", new Object[]{this.tmpDir, fileName, success});
                        }
                    }
                }
                catch (Exception e) {
                    success = false;
                    String msg = "LocalFileTempStorage [" + this.tmpDir + "] \u6570\u636e\u5904\u7406\u5931\u8d25: {" + fileName + "}, \u9519\u8bef\u4fe1\u606f: " + e.getMessage();
                    log.error(msg, (Throwable)e);
                }
                if (!success) continue;
                this.confirm(fileName);
                if (!log.isDebugEnabled()) continue;
                log.debug("\u5f52\u6863 LocalFileTempStorage [{}] \u6570\u636e\u5b8c\u6210: {} .", (Object)this.tmpDir, (Object)fileName);
            }
        }
    }

    private static <T> List<T> loadJsonFromFile(File jsonFile, Class<T> clazz) throws IOException {
        LinkedList<Object> result = new LinkedList<Object>();
        List jsonStrList = FileUtils.readLines((File)jsonFile, (String)"UTF-8");
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        for (String jsonStr : jsonStrList) {
            Object data = objectMapper.readValue(jsonStr, clazz);
            result.add(data);
        }
        return result;
    }

    private void confirm(String fileName) throws IOException {
        Path srcPath = Paths.get(this.readyDir, fileName);
        Path tagPath = Paths.get(CalendarSerialFolderManager.prepareFolder(this.historyDir), fileName);
        Files.move(srcPath, tagPath, new CopyOption[0]);
    }

    private String[] getReadyFiles() throws IOException {
        File folder = new File(this.readyDir);
        return this.getSonFiles(folder);
    }

    private String[] getTmpFiles() throws IOException {
        File folder = new File(this.tmpDir);
        return this.getSonFiles(folder);
    }

    private String[] getSonFiles(File folder) {
        Object[] files = folder.list();
        Arrays.sort(files);
        LinkedList<String> matchFileList = new LinkedList<String>();
        for (Object file : files) {
            File sonFile = Paths.get(folder.getAbsolutePath(), new String[]{file}).toFile();
            if (!sonFile.isFile() || !sonFile.getName().endsWith("v2")) continue;
            matchFileList.add(sonFile.getName());
        }
        return matchFileList.toArray(new String[0]);
    }

    private static String getTmpFolder(String baseDir, String className) {
        Path folderPath = Paths.get(baseDir + "/tmp/" + className, new String[0]);
        return LocalFileTempStorage.getFolderDir(folderPath);
    }

    private static String getReadyFolder(String baseDir, String className) {
        Path folderPath = Paths.get(baseDir + "/ready/" + className, new String[0]);
        return LocalFileTempStorage.getFolderDir(folderPath);
    }

    private static String getHistoryFolder(String baseDir, String className) {
        Path folderPath = Paths.get(baseDir + "/history/" + className, new String[0]);
        return LocalFileTempStorage.getFolderDir(folderPath);
    }

    private static String getErrorFolder(String baseDir, String className) {
        Path folderPath = Paths.get(baseDir + "/error/" + className, new String[0]);
        return LocalFileTempStorage.getFolderDir(folderPath);
    }

    private static String getFolderDir(Path folderPath) {
        return folderPath.toAbsolutePath().toString();
    }

    public static interface DataConsumer<T> {
        public boolean process(List<T> var1);
    }
}

