package com.bokesoft.distro.tech.commons.basis.flightrecord.utils;

import org.apache.commons.lang3.exception.ExceptionUtils;

import javax.sql.DataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * YFR 底层的公用逻辑
 */
public class YFRUtils {
    /** JVM启动时间 */
    private static final Long JVM_START_TIME = System.currentTimeMillis();

    public static Long getJvmStartTime(){
        return YFRUtils.JVM_START_TIME;
    }

    public static String buildThreadTrace() {
        Thread currentThread = Thread.currentThread();
        StringBuffer sb = new StringBuffer("Thread[" + currentThread.getName() + "," + currentThread.getId() + "]");
        sb.append(";\n");
        int limit = 25;
        for (StackTraceElement traceElement : currentThread.getStackTrace()) {
            if (limit > 0) {
                sb.append(traceElement.getClassName() + ":" + traceElement.getMethodName() + "#" + traceElement.getLineNumber());
                sb.append(";\n");
            }
            limit--;
        }
        return sb.toString();
    }

    public static String getDatasourceId(DataSource dataSource) {
        return dataSource.getClass().getName() + "@" + Integer.toHexString(dataSource.hashCode());
    }

    public static byte[] getClassBytes(Class<?> clazz) {
        String classPath = clazz.getName().replace('.', '/') + ".class";
        try (InputStream is = clazz.getClassLoader().getResourceAsStream(classPath);
             ByteArrayOutputStream buffer = new ByteArrayOutputStream()) {

                if (is == null) {
                    throw new RuntimeException("Class not found: " + classPath);
                }

                byte[] tempBuffer = new byte[1024];
                int bytesRead;
                while ((bytesRead = is.read(tempBuffer, 0, 1024)) != -1) {
                    buffer.write(tempBuffer, 0, bytesRead);
                }

                return buffer.toByteArray();
        } catch (IOException e) {
            return ExceptionUtils.wrapAndThrow(e);
        }
    }

    public static boolean isJREClass(Class<?> clazz) {
        return clazz.getClassLoader() == null;
    }
}
