package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.rediscache;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ClassInfo implements Externalizable {

    private String className;

    private byte[] classBytes;

    public ClassInfo() {
    }

    public ClassInfo(String className, byte[] classBytes) {
        this.className = className;
        this.classBytes = classBytes;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public byte[] getClassBytes() {
        return classBytes;
    }

    public void setClassBytes(byte[] classBytes) {
        this.classBytes = classBytes;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(className));
        Preconditions.checkArgument(classBytes != null);
        out.writeUTF(className);
        out.writeInt(classBytes.length);
        out.write(classBytes);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.className = in.readUTF();
        int len = in.readInt();
        this.classBytes = new byte[len];
        in.readFully(this.classBytes);
    }
}
