package com.bokesoft.distro.tech.commons.basis.flightrecord.struc;

import com.bokesoft.base.bokebase.instance.ProcessInstanceUtil;
import com.bokesoft.distro.tech.commons.basis.NetworkUtil;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.app.AppHealthCheckEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.bgtask.QuartzJobEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.rediscache.ClassBytePackageEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database.ConnectionCloseEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database.ConnectionOpenEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database.DatasourceCfgEvent;
import com.bokesoft.distro.tech.commons.basis.flightrecord.utils.YFRUtils;
import com.bokesoft.yigo.common.trace.TraceRecorder;

import java.io.Serializable;

/**
 * Yigo 应用的应用内部监控记录
 */
public class FlightRecordVO implements Serializable {
    /** 服务启动时间, 来自 {@link YFRUtils#getJvmStartTime()} */
    private long jvmStartTime;
    /** 当前应用实例 ID, 来自 {@link ProcessInstanceUtil#getInstanceId()} */
    private String instanceId;
    /** 当前应用的 hostname, 来自 {@link NetworkUtil#getHost()} */
    private String host;
    /** 当前应用的 ip 地址, 来自 {@link NetworkUtil#getIp()} */
    private String ip;
    /** 当前应用的进程 id, 来自 {@link ProcessInstanceUtil#getProcessId()} */
    private String pid;

    private String traceId;
    private String spanId;
    private String parentSpanId;

    private ConnectionOpenEvent connectionOpenEvent;
    private ConnectionCloseEvent connectionCloseEvent;
    private DatasourceCfgEvent datasourceCfgEvent;
    private ClassBytePackageEvent classBytePackageEvent;
    private QuartzJobEvent quartzJobEvent;
    private AppHealthCheckEvent appHealthCheckEvent;

    public static FlightRecordVO buildBase(){
        FlightRecordVO result = new FlightRecordVO();
        result.setJvmStartTime(YFRUtils.getJvmStartTime());
        result.setHost(NetworkUtil.getHost());
        result.setIp(NetworkUtil.getIp());
        result.setInstanceId(ProcessInstanceUtil.getInstanceId());
        result.setPid(ProcessInstanceUtil.getProcessId());
        result.setTraceId(TraceRecorder.getTraceId());
        result.setSpanId(TraceRecorder.getSpanId());
        result.setParentSpanId(TraceRecorder.getParentSpanId());
        return result;
    }

    public long getJvmStartTime() {
        return jvmStartTime;
    }

    public void setJvmStartTime(long jvmStartTime) {
        this.jvmStartTime = jvmStartTime;
    }

    public String getInstanceId() {
        return instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPid() {
        return pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getSpanId() {
        return spanId;
    }

    public void setSpanId(String spanId) {
        this.spanId = spanId;
    }

    public String getParentSpanId() {
        return parentSpanId;
    }

    public void setParentSpanId(String parentSpanId) {
        this.parentSpanId = parentSpanId;
    }

    public ConnectionOpenEvent getConnectionOpenEvent() {
        return connectionOpenEvent;
    }

    public void setConnectionOpenEvent(ConnectionOpenEvent connectionOpenEvent) {
        this.connectionOpenEvent = connectionOpenEvent;
    }

    public ConnectionCloseEvent getConnectionCloseEvent() {
        return connectionCloseEvent;
    }

    public void setConnectionCloseEvent(ConnectionCloseEvent connectionCloseEvent) {
        this.connectionCloseEvent = connectionCloseEvent;
    }

    public DatasourceCfgEvent getDatasourceCfgEvent() {
        return datasourceCfgEvent;
    }

    public void setDatasourceCfgEvent(DatasourceCfgEvent datasourceCfgEvent) {
        this.datasourceCfgEvent = datasourceCfgEvent;
    }

    public ClassBytePackageEvent getClassBytePackageEvent() {
        return classBytePackageEvent;
    }

    public void setClassBytePackageEvent(ClassBytePackageEvent classBytePackageEvent) {
        this.classBytePackageEvent = classBytePackageEvent;
    }

    public QuartzJobEvent getQuartzJobEvent() {
        return quartzJobEvent;
    }

    public void setQuartzJobEvent(QuartzJobEvent quartzJobEvent) {
        this.quartzJobEvent = quartzJobEvent;
    }

    public AppHealthCheckEvent getAppRunningEvent() {
        return appHealthCheckEvent;
    }

    public void setAppRunningEvent(AppHealthCheckEvent appHealthCheckEvent) {
        this.appHealthCheckEvent = appHealthCheckEvent;
    }

    @Override
    public String toString() {
        return "FlightRecordVO{" +
                "jvmStartTime=" + jvmStartTime +
                ", instanceId='" + instanceId + '\'' +
                ", host='" + host + '\'' +
                ", ip='" + ip + '\'' +
                ", pid='" + pid + '\'' +
                ", traceId='" + traceId + '\'' +
                ", spanId='" + spanId + '\'' +
                ", connectionOpenEvent=" + connectionOpenEvent +
                ", connectionCloseEvent=" + connectionCloseEvent +
                ", datasourceCfgEvent=" + datasourceCfgEvent +
                ", classBytePackageEvent=" + classBytePackageEvent +
                ", quartzJobEvent=" + quartzJobEvent +
                ", appHealthCheckEvent="+ appHealthCheckEvent +
                '}';
    }
}
