package com.bokesoft.distro.tech.commons.basis.flightrecord.config;

import com.bokesoft.distro.tech.commons.basis.flightrecord.impl.DefaultDataSourceCfgResolver;
import com.bokesoft.distro.tech.commons.basis.flightrecord.intf.IDataSourceCfgResolver;
import com.bokesoft.distro.tech.commons.basis.flightrecord.intf.IFlightRecordDataRecorder;

/**
 * 涉及收集信息的实现类的注册和发现
 */
public class FlightRecordToolsRegistry {
    private static IDataSourceCfgResolver datasourceCfgResolver = new DefaultDataSourceCfgResolver();
    private static IFlightRecordDataRecorder recorder;

    public static IDataSourceCfgResolver getDatasourceCfgResolver() {
        return datasourceCfgResolver;
    }

    public static void setDatasourceCfgResolver(IDataSourceCfgResolver datasourceCfgResolver) {
        FlightRecordToolsRegistry.datasourceCfgResolver = datasourceCfgResolver;
    }

    public static IFlightRecordDataRecorder getRecorder() {
        return recorder;
    }

    public static void setRecorder(IFlightRecordDataRecorder recorder) {
        FlightRecordToolsRegistry.recorder = recorder;
    }
}
