package com.bokesoft.distro.tech.commons.basis.files;

import java.io.InputStream;

/**
 * 最基本的, 在分布式环境下的文件存储的接口定义
 */
public interface IFileStorage {
	
	/**
	 * 上传数据, 获得文件 ID
	 * 
	 * @param prefix 文件前缀, 用于如 bucketName 的传递等
	 * @param inputStream 文件内容的输入流
	 * @return fileId 文件UUID
	 * @throws Exception  可能IO异常,无法保存文件
	 */
	public String upload(String prefix, InputStream inputStream) throws Exception;

	/**
	 * 通过文件 ID 下载数据
	 * 
	 * @param prefix 文件前缀, 用于如 bucketName 的传递等
	 * @param fileId 文件UUID
	 * @return 文件的二进制数组
	 * @throws Exception 可能IO异常,找不到资源文件
	 */
	public byte[] download(String prefix, String fileId) throws Exception;

	/**
	 * 通过文件 ID 删除数据
	 * 
	 * @param prefix 文件前缀, 用于如 bucketName 的传递等
	 * @param fileId 文件UUID
	 * @return 执行结果的boolean值,true表示成功删除
	 * @throws Exception 可能IO异常,找不到历史文件
	 */
	public boolean delete(String prefix, String fileId) throws Exception;
}
