package com.bokesoft.distro.tech.commons.basis.data;

import java.io.Serializable;

/**
 * 分页查询的结果数据对象
 */
public class PagingSearchResult<T extends Object> implements Serializable{
	private static final long serialVersionUID = 20150706L;
	/**
	 * 页码,起始页是0
	 */
	private int pageNo;
	/**
	 * 分页大小
	 */
	private int pageSize;
	/**
	 * 总数据量
	 */
	private long totalRecords;
	/**
	 * 总页数
	 */
	private int pageCount;
	
	private T data;

	public PagingSearchResult(int pageNo, int pageSize, long totalRecords){
		this.pageNo = pageNo;
		this.pageSize = pageSize;
		this.totalRecords = totalRecords;
		this.pageCount = Double.valueOf(Math.ceil(1.0*totalRecords/pageSize)).intValue();
		if (this.pageCount<1){
			this.pageCount=1;
		}
		if (this.pageNo > this.pageCount-1){
			this.pageNo = this.pageCount-1;
		}
	}
	
	public int getPageNo() {
		return pageNo;
	}
	public int getPageSize() {
		return pageSize;
	}
	public long getTotalRecords() {
		return totalRecords;
	}

	public T getData() {
		return data;
	}
	public void setData(T data) {
		this.data = data;
	}

	public int getPageCount() {
		return pageCount;
	}
}
