package com.bokesoft.distro.tech.commons.basis.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 通用的服务调用结果对象
 * @author lee
 * @param <T> 调用结果返回数据的类型
 */
public class CommonResult<T> extends BaseResult<T>{
	private static final long serialVersionUID = 1L;
	/**
	 * 附加信息
	 */
	private Map<String, Object> attachments;


	/**
	 * 默认构造函数, 仅用于 JSON 方式的数据传输过程
	 */
	public CommonResult() {
		//Do nothing
	}

	private CommonResult(int code, String msg, T data, boolean isSuccess) {
		setCode(code);
		setMessage(msg);
		setData(data);
		setSuccess(isSuccess);
	}

	/**
	 * 创建成功执行结果
	 * @param code 执行结果返回码
	 * @param message 执行情况信息, 可以为空
	 * @param data 结果数据, 可以为空
	 */
	public static <T> CommonResult<T> success(int code, String message, T data){
		return new CommonResult<T>(code, message, data, true);
	}

	/**
	 * 创建成功执行结果
	 * @param message 执行情况信息, 不能为空
	 * @param data 结果数据, 可以为空
	 */
	public static <T> CommonResult<T> success(CodeMessage message, T data){
		return success(message.getCode(), message.getMessage(), data);
	}

	/**
	 * 创建成功执行结果
	 * @param message 执行情况信息, 不能为空
	 */
	public static CommonResult<Object> success(CodeMessage message){
		return success(message.getCode(), message.getMessage(), null);
	}

	/**
	 * 创建默认的成功执行结果
	 * @param data 结果数据, 可以为空
	 */
	public static <T> CommonResult<T> success(T data){
		return success(GENERAL_CODE_SUCCESS, GENERAL_MSG_SUCCESS, data);
	}

	/**
	 * 创建失败执行结果
	 * @param code 执行结果返回码
	 * @param message 执行情况信息, 可以为空
	 * @param data 结果数据, 可以为空
	 */
	public static <T> CommonResult<T> failure(int code, String message, T data){
		return new CommonResult<T>(code, message, data, false);
	}

	/**
	 * 创建默认的失败执行结果
	 * @param message 执行情况信息, 不能为空
	 * @param data 结果数据, 可以为空
	 */
	public static <T> CommonResult<T> failure(CodeMessage message, T data){
		return failure(message.getCode(), message.getMessage(), data);
	}

	/**
	 * 创建默认的失败执行结果
	 * @param message 执行情况信息, 不能为空
	 */
	public static CommonResult<Object> failure(CodeMessage message){
		return failure(message.getCode(), message.getMessage(), null);
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ServiceResult [success=");
		builder.append(success);
		builder.append(", code=");
		builder.append(getCode());
		builder.append(", ");
		if (attachments != null) {
			builder.append("attachments=");
			builder.append(attachments);
			builder.append(", ");
		}
		if (getMessage() != null) {
			builder.append("message=");
			builder.append(getMessage());
			builder.append(", ");
		}
		if (getData() != null) {
			builder.append("data=");
			builder.append(getData());
		}
		builder.append("]");
		return builder.toString();
	}

	public Map<String, Object> getAttachments() {
		if (null == attachments) {
			return null;
		}
		return Collections.unmodifiableMap(attachments);
	}

	/**
	 * @deprecated
	 * 此方法不建议使用,仅用作序列化
	 * @param attachments 附属信息
	 */
	@Deprecated
	public void setAttachments(Map<String, Object> attachments) {
		this.attachments = attachments;
	}

	/**
	 * 添加附属信息
	 * @param key key
	 * @param value value
	 */
	public CommonResult<T> addAttachment(String key,Object value){
		if (null == attachments) {
			attachments = new HashMap<>();
		}
		attachments.put(key,value);
		return this;
	}

}
