package com.bokesoft.distro.tech.commons.basis.coordinate.impl;

import com.bokesoft.distro.tech.commons.basis.coordinate.intf.ILeaderStatusDetector;
import com.bokesoft.distro.tech.commons.basis.coordinate.struct.LeaderStatusConfig;

import java.util.HashSet;
import java.util.Set;

public class SimpleLeaderStatusDetector implements ILeaderStatusDetector {

    private Set<String> tags = new HashSet<>();

    @Override
    public boolean isLeader(String tag) {
        if (!tags.contains(tag)) {
            throw new IllegalArgumentException("不存在的业务标签: " + tag);
        }
        return true;
    }

    @Override
    public void register(String tag, LeaderStatusConfig config) {
        tags.add(tag);
    }

}
