package com.bokesoft.distro.tech.commons.basis;

/**
 * 处理 ”shebang“(即 ”#!“ 标识，参考 https://en.wikipedia.org/wiki/Shebang_%28Unix%29 )标识的工具类
 */
public class ShebangUtil {
	private static final String SHEBANG_HEAD = "#!";
	private static final char[] SHEBANG_ENDS = new char[]{'\n', '\r', ':'};
	
	private static int getShebangEnds(String exp){
		if (exp.startsWith(SHEBANG_HEAD)){
			int idx = -1;
			char[] toFind = SHEBANG_ENDS;
			for (char c : toFind) {
				int find = exp.indexOf(c);
				if (find >= 0 && (idx < 0 || find < idx)) {
					idx = find;
				}
			}
			if (idx<0){
				// 表达式只有一行, 那么就都是 shebang 没有代码了
				return exp.length();
			}else{
				return idx+1;
			}
		}else{
			// 全部是代码区域
			return 0;
		}
	}

	public static String getShebang(String exp){
		if (null==exp){
			return null;
		}
		exp = exp.trim();

		int idx = getShebangEnds(exp);
		String firstLine = exp.substring(0, idx);
		if (firstLine.startsWith(SHEBANG_HEAD)){
			String shebang = firstLine.substring(SHEBANG_HEAD.length());

			for (char end : SHEBANG_ENDS) {
				if (end == shebang.charAt(shebang.length() - 1)) {
					shebang = shebang.substring(0, shebang.length() - 1);
				}
			}
			
			shebang = shebang.trim();
			
			return shebang;
		}else{
			return null;
		}
	}

}
