package com.bokesoft.distro.tech.commons.basis;

import javax.servlet.http.HttpServletRequest;

/**
 * servlet请求相关工具方法
 */
public class ServletRequestUtil {
    private static final String UNKNOWN = "unknown";
    private static final String SEPARATOR = ",";

    /**
     * 获取相应的客户端 IP 地址
     * @param request
     * @return
     */
    public static String getClientIp(HttpServletRequest request) {
        if (request == null) {
            return "unknown";
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        // 对于通过多个代理的情况，分割出第一个 IP
        if (ip.indexOf(SEPARATOR) > -1) {
            ip = ip.substring(0, ip.indexOf(SEPARATOR));
        }
        return ip;
    }
}
