/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.io.internal;

import java.time.LocalDate;

public class FolderExpiredCalcTool {
    private static final int MIN_VALID_YEAR = 2000;

    public static LocalDate parseDateFromPath(String path) {
        String[] parts;
        if (null == path) {
            path = "";
        }
        String partYear = (parts = path.split("/")).length >= 1 ? parts[0] : null;
        String partMonth = parts.length >= 2 ? parts[1] : null;
        String partDay = parts.length >= 3 ? parts[2] : null;
        Integer year = FolderExpiredCalcTool.parseYear(partYear);
        if (null == year) {
            return FolderExpiredCalcTool.toLocalDate(2000, 1, 1);
        }
        if (null == partMonth) {
            return FolderExpiredCalcTool.toLocalDate(year, 12, 31);
        }
        Integer month = FolderExpiredCalcTool.parseMonth(partMonth);
        if (null == month) {
            return FolderExpiredCalcTool.toLocalDate(year, 1, 1);
        }
        if (null == partDay) {
            return FolderExpiredCalcTool.toLocalDate(year, month, FolderExpiredCalcTool.getMonthLastDay(year, month));
        }
        Integer day = FolderExpiredCalcTool.parseDay(partDay, FolderExpiredCalcTool.getMonthLastDay(year, month));
        if (null == day) {
            return FolderExpiredCalcTool.toLocalDate(year, month, 1);
        }
        return FolderExpiredCalcTool.toLocalDate(year, month, day);
    }

    private static LocalDate toLocalDate(int year, int month, int day) {
        return LocalDate.of(year, month, day);
    }

    private static Integer parseYear(String partYear) {
        Integer result = null;
        if (null != partYear && FolderExpiredCalcTool.isInteger(partYear) && (result = Integer.valueOf(Integer.parseInt(partYear))) < 2000) {
            result = null;
        }
        return result;
    }

    private static Integer parseMonth(String partMonth) {
        Integer result = null;
        if (FolderExpiredCalcTool.isInteger(partMonth) && ((result = Integer.valueOf(Integer.parseInt(partMonth))) < 1 || result > 12)) {
            result = null;
        }
        return result;
    }

    private static Integer parseDay(String partDay, int monthLastDay) {
        Integer result = null;
        if (FolderExpiredCalcTool.isInteger(partDay) && ((result = Integer.valueOf(Integer.parseInt(partDay))) < 1 || result > monthLastDay)) {
            result = null;
        }
        return result;
    }

    private static int getMonthLastDay(int year, int month) {
        LocalDate tempDate = LocalDate.of(year, month, 1);
        return tempDate.lengthOfMonth();
    }

    private static boolean isInteger(String str) {
        return str.matches("-?\\d+");
    }
}

