/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.io;

import com.bokesoft.distro.tech.commons.basis.io.internal.FolderExpiredCalcTool;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalendarSerialFolderManager {
    private static final Logger log = LoggerFactory.getLogger(CalendarSerialFolderManager.class);
    private static final String DATA_FOMART_YYYYMMDD = "yyyy/MM/dd";

    public static String prepareFolder(String basePath) throws IOException {
        return CalendarSerialFolderManager.prepareFolder(basePath, new Date());
    }

    public static String prepareFolder(String basePath, Date date) throws IOException {
        SimpleDateFormat df = new SimpleDateFormat(DATA_FOMART_YYYYMMDD);
        Path folderPath = Paths.get(basePath + "/" + df.format(date), new String[0]);
        FileUtils.forceMkdir((File)folderPath.toFile());
        return folderPath.toAbsolutePath().toString();
    }

    public static void clearExpiredFiles(String basePath, int expiredDays) throws IOException {
        File folder = new File(basePath);
        if (!folder.exists()) {
            log.warn("\u65e5\u671f\u6839\u76ee\u5f55 [{}] \u4e0d\u5b58\u5728, \u8df3\u8fc7\u5904\u7406", (Object)basePath);
            return;
        }
        List<String> children = CalendarSerialFolderManager.getSubTreePath(basePath);
        if (children.isEmpty()) {
            log.warn("\u65e5\u671f\u6839\u76ee\u5f55 [{}] \u4e3a\u7a7a\u76ee\u5f55, \u8df3\u8fc7\u5904\u7406", (Object)basePath);
        }
        List<String> needRemoveList = CalendarSerialFolderManager.getExpiredFolderPath(children, CalendarSerialFolderManager.getExpiredCalendar(expiredDays));
        log.info("\u65e5\u671f\u6839\u76ee\u5f55 [{}] - \u6e05\u9664\u8fc7\u671f({}\u5929)\u7684\u5b50\u76ee\u5f55: {} ...", new Object[]{basePath, expiredDays, needRemoveList});
        for (String needRemovePath : needRemoveList) {
            FileUtils.deleteDirectory((File)new File(basePath, needRemovePath));
        }
    }

    protected static List<String> getExpiredFolderPath(List<String> allPosterityFolder, Calendar expiryDateC) {
        LinkedList<String> result = new LinkedList<String>();
        if (null != allPosterityFolder && !allPosterityFolder.isEmpty()) {
            LocalDate expiryDateL = LocalDateTime.ofInstant(expiryDateC.toInstant(), expiryDateC.getTimeZone().toZoneId()).toLocalDate();
            for (String posterityFolder : allPosterityFolder) {
                LocalDate dirDate = FolderExpiredCalcTool.parseDateFromPath(posterityFolder);
                if (!expiryDateL.isAfter(dirDate)) continue;
                result.add(posterityFolder);
            }
            result.sort(new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    if (s1 == null && s2 == null) {
                        return 0;
                    }
                    if (s1 == null) {
                        return -1;
                    }
                    if (s2 == null) {
                        return 1;
                    }
                    return s2.compareTo(s1);
                }
            });
        }
        return result;
    }

    private static List<String> getSubTreePath(String basePath) throws IOException {
        final Path rootDir = Paths.get(basePath, new String[0]);
        final ArrayList<String> relativePaths = new ArrayList<String>();
        Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                Path relativePath = rootDir.relativize(dir);
                if (!relativePath.toString().isEmpty()) {
                    relativePaths.add(relativePath.toString().replaceAll("\\\\", "/"));
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return relativePaths;
    }

    private static Calendar getExpiredCalendar(int expiredDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1 * expiredDays + 1);
        return calendar;
    }
}

