/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.distro.tech.commons.basis.coordinate.struct;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.json.JSONString;

public final class Semaphore
implements JSONString {
    public final String key;
    public final LocalDateTime time;
    private String tag;
    private String session;

    public Semaphore(String key) {
        this.key = key;
        this.time = LocalDateTime.now();
    }

    private Semaphore(String key, LocalDateTime time) {
        this.key = key;
        this.time = time;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String toJSONString() {
        JSONObject js = new JSONObject();
        js.put("key", (Object)this.key);
        js.put("time", (Object)this.time.format(DateTimeFormatter.ISO_DATE_TIME));
        js.put("tag", (Object)this.tag);
        js.put("session", (Object)this.session);
        return js.toString();
    }

    public String toString() {
        return String.format("%s[%s,%s,%s]", this.key, this.time, this.tag, this.session);
    }

    public static Semaphore fromJSONString(String str) {
        JSONObject obj = new JSONObject(str);
        String key = obj.optString("key");
        String time = obj.optString("time", "");
        Semaphore semaphore = new Semaphore(key, StringUtils.isBlank((CharSequence)time) ? null : LocalDateTime.from(DateTimeFormatter.ISO_DATE_TIME.parse(time)));
        semaphore.tag = obj.optString("tag", null);
        semaphore.session = obj.optString("session", null);
        return semaphore;
    }
}

