package com.bokesoft.distro.tech.commons.basis.trace;

import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.bokesoft.distro.tech.commons.basis.trace.intf.ITraceSupplier;
import com.bokesoft.yigo.common.trace.TraceConstants;
import com.bokesoft.yigo.common.trace.TraceRecorder;
import com.bokesoft.yigo.common.trace.TraceSystemManager;

import com.bokesoft.yigo.common.trace.intf.InstanceInspectable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.event.Level;

/**
 * {@deprecated} 预计在下个大版本删除,相关方法请直接使用 {@link TraceRecorder},{@link TraceSystemManager}的API
 */
@Deprecated
public class TraceUtil {
	private static final Logger LOGGER = LoggerFactory.getLogger(TraceUtil.class);

	/**
	 * 包装执行过程,协助日志记录相应的实例信息,执行耗时等
	 * @param supplier 回调函数,即执行过程函数
	 * @param instance 当前执行实例,如果实现{@link InstanceInspectable}可获取更加详细的实例节点信息
	 * @param withNewSpan 是否在之后切分spanid,视为另一个业务线程
	 * @param processLogger 输出日志载体,可以为null,使用{@link TraceUtil#LOGGER}
	 * @param processLogLevel 指定日志输出级别,可以为null,使用{@link Level#INFO}
	 */
	public static <T> T withTraceLog(ITraceSupplier<T> supplier,
									 Object instance, boolean withNewSpan, Logger processLogger, Level processLogLevel){
		return TraceSystemManager.withTraceLog(supplier,instance,withNewSpan,processLogger,processLogLevel);
	}

	/**
	 * 将数据记录,待报错时,打印出来
	 * @param msg 对保存数据的说明
	 * @param data 需要记录的数据
	 */
	public static void traceData(String msg, Object data){
		traceData(msg, data, false);
	}

	/**
	 * 将数据记录,待报错时或根据打印模式,打印出来
	 * @param msg 对保存数据的说明
	 * @param data 需要记录的数据
	 * @param isAlways 永久输出模式
	 */
	public static void traceData(String msg,Object data,boolean isAlways){
		TraceRecorder.traceData(msg, data, isAlways);
	}


	/**
	 * 请使用 {@link #wrapFilter(HttpServletRequest, HttpServletResponse, FilterChain, Logger, Level)}  }方法
	 */
	public static void wrapFilter(HttpServletRequest request, HttpServletResponse response,FilterChain chain){
		wrapFilter(request,response,chain,LOGGER,Level.DEBUG);
	}


	/**
	 * 对当前请求线程添加 trace id, span id, parent span id 等等 trace 信息, 用于 Servlet Filter 中
	 * @param request HttpServletRequest实例
	 * @param response HttpServletRespons实例
	 * @param chain filter连
	 * @param logger 日志记录器实例
	 */
	public static void wrapFilter(HttpServletRequest request, HttpServletResponse response,FilterChain chain,
								  Logger logger,Level logLevel) {
		throw new UnsupportedOperationException("该版本不再支持,请勿使用");
	}


	/**
	 * 更新当前线程的 trace id
	 * @param traceId traceid
	 */
	public static void updateTraceId(String traceId) {
		TraceSystemManager.initializeTraceContext(traceId,
				TraceRecorder.getSpanId(),TraceRecorder.getParentSpanId());
	}

	/**
	 * 获取当前线程的 traceId
	 * @return tracId值
	 */
	public static String getTraceId() {
		return TraceRecorder.getTraceId();
	}

	/**
	 * 获取当前线程的 parentSpanId
	 * @return parentSpanId 值
	 */
	public static String getParentSpanId() {
		return TraceRecorder.getParentSpanId();
	}

	/**
	 * 获取当前线程的 spanId
	 * @return spanId值
	 */
	public static String getSpanId() {
		return  TraceRecorder.getSpanId();
	}

}