package com.bokesoft.distro.tech.commons.basis.io.internal;

import java.util.concurrent.TimeUnit;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 检查线程,用于检查哪些 writer已超过 区块时间,可以移至准备区目录中
 */
public class WriterMonitor implements Runnable{
    private Logger logger = LoggerFactory.getLogger(WriterMonitor.class);
    @Override
    public void run() {
        for(;;){
            try {
                for(LocalFileTempWriter<?> writer:TempWriterManager.WRITERS_CACHE.values()){
                    writer.tryFlush();
                }
                TimeUnit.SECONDS.sleep(TempWriterManager.MONITOR_ROLLING_TIME);
            } catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
    }
}
