package com.bokesoft.distro.tech.commons.basis.flightrecord.struc.database;

import java.io.Serializable;

import com.bokesoft.distro.tech.commons.basis.flightrecord.utils.YFRUtils;

/**
 * 数据库连接打开事件
 */
public class ConnectionOpenEvent implements Serializable {
    private String datasourceId;
    private String connInstId;
    private long openTime;
    private String stackTrace;

    public static ConnectionOpenEvent build(String datasourceId, String connInstId){
        ConnectionOpenEvent e = new ConnectionOpenEvent();
        e.datasourceId = datasourceId;
        e.connInstId = connInstId;
        e.openTime = System.currentTimeMillis();
        e.stackTrace = YFRUtils.buildThreadTrace();
        return e;
    }

    public ConnectionOpenEvent(){
        //JSON 反序列化等场景需要
    }

    public String getDatasourceId() {
        return datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getConnInstId() {
        return connInstId;
    }

    public void setConnInstId(String connInstId) {
        this.connInstId = connInstId;
    }

    public long getOpenTime() {
        return openTime;
    }

    public void setOpenTime(long openTime) {
        this.openTime = openTime;
    }

    public String getStackTrace() {
        return stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    @Override
    public String toString() {
        return "ConnectionOpenEvent [datasourceId=" + datasourceId + ", connInstId=" + connInstId + ", openTime="
                + openTime + "]";
    }

}

